package com.jsmframe.rest.resp;

import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.pair.Pair;
import com.jsmframe.utils.StringUtil;

public class StringResp<T> extends CodeResp<String> {
    @FieldAnn(comments = "响应结果")
    public T result;

    public StringResp() {
        super();
        this.setPair(BasePairConsts.OK);
    }

    public void setPair(Pair<String> pair) {
        this.code = pair.getCode();
        this.message = pair.getMessage();
    }

    @Override
    public String toString() {
        return StringUtil.toJson(this);
    }

}
