package com.jsmframe.oauth.password;

import com.alibaba.fastjson.TypeReference;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.ThreadLocalUtil;

import java.lang.reflect.Type;

/**
 * 中间 资源API server 或者 三方应用server
 */
public class OauthContext {

    public static void setAccessToken(String token) {
        ThreadLocalUtil.oauthAccessTokenTL.set(token);
    }

    public static void setVerifyResult(String result) {
        ThreadLocalUtil.oauthVerifyResultTL.set(result);
    }

    public static String getVerifyResult() {
        return ThreadLocalUtil.oauthVerifyResultTL.get();
    }

    public static <T> T getVerifyResult(Class<T> clazz) {
        String verifyResult = getVerifyResult();
        if (!StringUtil.isEmpty(verifyResult)) {
            return StringUtil.parseObject(verifyResult, clazz);
        }
        return null;
    }

    public static <T> T getVerifyResult(Type type) {
        String verifyResult = getVerifyResult();
        if (!StringUtil.isEmpty(verifyResult)) {
            return StringUtil.parseObject(verifyResult, type);
        }
        return null;
    }

    public static <T> T getVerifyResult(TypeReference<T> typeReference) {
        String verifyResult = getVerifyResult();
        if (!StringUtil.isEmpty(verifyResult)) {
            return StringUtil.parseObject(verifyResult, typeReference);
        }
        return null;
    }

}
