package com.jsmframe.mybatis;

import java.util.regex.Matcher;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;

public class SqlServerDialect extends AbstractDialect {

	@Override
	public String concatCountSql(String sql) {
		StringBuffer sb = new StringBuffer("select count(*) from ");
		int beginIndex = findBeginIdx(sql);
		Matcher orderByMatcher = orderByPattern.matcher(sql);
		int lastIndex = sql.lastIndexOf(")");
		if (lastIndex != -1 && orderByMatcher.find(lastIndex)) {
			sb.append(sql.substring(beginIndex, orderByMatcher.start()));
		} else {
			sb.append(sql.substring(beginIndex));
		}
		return sb.toString();
	}
	
	@Override
	public String concatPageSql(String sql, int startRow, int pageSize) {
		StringBuilder sqlBuilder = new StringBuilder(sql.length() + 200);
		sqlBuilder.append("SELECT * FROM ( SELECT TOP ");
		sqlBuilder.append(pageSize);
		sqlBuilder.append(" * ");
        sqlBuilder.append(sql);
        sqlBuilder.append(" FROM (SELECT TOP ");
        sqlBuilder.append(startRow);
        sqlBuilder.append(" * ");
        sqlBuilder.append(getSqlBody(sql));
        sqlBuilder.append(") f");//TODO maybe need order by condition
        sqlBuilder.append(") s");
        return sqlBuilder.toString();
	}

	public SqlSource getSqlSource(BoundSql boundSql) {

		return new MySqlSource(boundSql);

	}

	public class MySqlSource implements SqlSource {
		BoundSql boundSql;

		public MySqlSource(BoundSql boundSql) {
			this.boundSql = boundSql;
		}

		@Override
		public BoundSql getBoundSql(Object parameterObject) {
			return boundSql;
		}
	}

}
