package com.jsmframe.context;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import com.jsmframe.jedis.JedisService;
import com.jsmframe.service.CacheService;
import com.jsmframe.utils.QuartzUtil;
import org.slf4j.Logger;

import com.jsmframe.service.JsmAppListenerService;
import com.jsmframe.utils.LogUtil;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * @author longzl / @createOn 2010-8-28
 * 启动服务时 初始工作
 */
public class JsmInitListener implements ServletContextListener {
    private static Logger logger = LogUtil.log(JsmInitListener.class);

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(sce.getServletContext());
        JsmAppListenerService appListenerService = SpringContext.getBean(JsmAppListenerService.class, wac);
        if (appListenerService != null) {
            appListenerService.close(sce);
        }
        QuartzUtil.shutdownJobs();
        CacheService cacheService = SpringContext.getBean(CacheService.class);
        if (cacheService != null) {
            cacheService.close();
        }
        logger.info("app close complete!");
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        WebContext.setContextPath(sce.getServletContext().getContextPath());// /ljdy
        WebContext.setRealPath(sce.getServletContext().getRealPath("/"));// d:/ljdy
        System.setProperty("file.encoding", "utf-8");
//        AppContext.init();
        logger.info("jsm-frame init complete!");
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(sce.getServletContext());
        JsmAppListenerService appListenerService = SpringContext.getBean(JsmAppListenerService.class, wac);
        if (appListenerService != null) {
            appListenerService.init(sce);
        }
        this.appContextInitialized(sce);
        logger.info("app init complete!");

        // 加载初始化数据
//		ScheduleTaskService sheduleTaskService = SpringContext.getBean(ScheduleTaskService.class);
//		sheduleTaskService.initSheduleJobs();
    }

    protected void appContextInitialized(ServletContextEvent sce) {

    }

}
