package com.jsmframe.context;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.PropUtil;
import com.jsmframe.utils.StringUtil;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * 加载顺序 project.properties --> app-base.properties --> app.properties
 */
public class AppContext {
    private static org.slf4j.Logger logger = LogUtil.log(AppContext.class);
    private static Map<String, String> propMap = new HashMap<>();
    private static boolean devModel = true;
    private static boolean jedisSession = false;

    static {
        init();
    }

    public static boolean isDevModel() {
        return devModel;
    }

    public static boolean isJedisSession() {
        return jedisSession;
    }

    public static String getDirect(String key) {
        String val = PropUtil.get(key, "app.properties");
        if (val != null) {
            return val;
        }
        val = PropUtil.get(key, "project.properties");
        if (val != null) {
            return val;
        }
        return null;
    }

    public static String get(String key, String defaultVal) {
        String res = get(key);
        return res == null ? defaultVal : res;
    }

    public static String get(String key) {
        return propMap.get(key);
    }

    public static Integer getAsInteger(String key) {
        return getAsInteger(key, null);
    }

    public static Integer getAsInteger(String key, Integer defaultVal) {
        try {
            String val = get(key);
            return val == null ? defaultVal : StringUtil.toInteger(val, defaultVal);
        } catch (Exception e) {
            logger.error("getAsInteger error! key {}", key);
            return null;
        }
    }

    public static Short getAsShort(String key) {
        return getAsShort(key, null);
    }

    public static Short getAsShort(String key, Short defaultVal) {
        try {
            String val = get(key);
            return val == null ? defaultVal : StringUtil.toShort(val, defaultVal);
        } catch (Exception e) {
            logger.error("getAsShort error! key {}", key);
            return null;
        }
    }

    public static Byte getAsByte(String key) {
        return getAsByte(key, null);
    }

    public static Byte getAsByte(String key, Byte defaultVal) {
        try {
            String val = get(key);
            return val == null ? defaultVal : StringUtil.toByte(val, defaultVal);
        } catch (Exception e) {
            logger.error("getAsByte error! key {}", key);
            return null;
        }
    }

    public static Float getAsFloat(String key) {
        return getAsFloat(key, null);
    }

    public static Float getAsFloat(String key, Float defaultVal) {
        try {
            String val = get(key);
            return val == null ? defaultVal : StringUtil.toFloat(val, defaultVal);
        } catch (Exception e) {
            logger.error("getAsFloat error! key {}", key);
            return null;
        }
    }

    public static Long getAsLong(String key) {
        return getAsLong(key, null);
    }

    public static Long getAsLong(String key, Long defaultVal) {
        try {
            String val = get(key);
            return val == null ? defaultVal : StringUtil.toLong(val, defaultVal);
        } catch (Exception e) {
            logger.error("getAsLong error! key {}", key);
            return null;
        }
    }

    public static Boolean getAsBoolean(String key) {
        return getAsBoolean(key, null);
    }

    public static Boolean getAsBoolean(String key, Boolean defaultVal) {
        try {
            String val = get(key);
            return val == null ? defaultVal : StringUtil.toBoolean(val, defaultVal);
        } catch (Exception e) {
            logger.error("getAsBoolean error! key {}", key);
            return null;
        }
    }

    private static void init() {
        loadPropMap();
        devModel = getAsBoolean("dev.model");
        jedisSession = getAsBoolean("jedis.session");
        logger.info("devModel:{}", devModel);
        logger.info("jedisSession:{}", jedisSession);
        Properties prop = System.getProperties();
        String httpProxyHost = get("http.proxyHost");
        String httpProxyPort = get("http.proxyPort");
        String httpNonProxyHosts = get("http.nonProxyHosts");
        String httpsProxyHost = get("https.proxyHost");
        String httpsProxyPort = get("https.proxyPort");
        String httpsNonProxyHosts = get("https.nonProxyHosts");
        String ftpProxyHost = get("ftp.proxyHost");
        String ftpProxyPort = get("ftp.proxyPort");
        String ftpNonProxyHosts = get("ftp.nonProxyHosts");
        String socksProxyHost = get("socks.proxyHost");
        String socksProxyPort = get("socks.proxyPort");
//		String socksNonProxyHosts = get("socks.nonProxyHosts");

        String proxyUsername = get("proxy.username");
        String proxyPassword = get("proxy.password");
        if (!StringUtil.isEmpty(httpProxyHost)) {
            logger.info("http.proxyHost:{}", httpProxyHost);
            logger.info("http.proxyPort:{}", httpProxyPort);
            logger.info("http.nonProxyHosts:{}", httpNonProxyHosts);
            prop.setProperty("http.proxyHost", httpProxyHost);
            prop.setProperty("http.proxyPort", httpProxyPort);
            prop.setProperty("http.nonProxyHosts", httpNonProxyHosts);
        }
        if (!StringUtil.isEmpty(httpsProxyHost)) {
            logger.info("https.proxyHost:{}", httpsProxyHost);
            logger.info("https.proxyPort:{}", httpsProxyPort);
            logger.info("https.nonProxyHosts:{}", httpsNonProxyHosts);
            prop.setProperty("https.proxyHost", httpsProxyHost);
            prop.setProperty("https.proxyPort", httpsProxyPort);
            prop.setProperty("https.nonProxyHosts", httpsNonProxyHosts);
        }
        if (!StringUtil.isEmpty(ftpProxyHost)) {
            logger.info("ftp.proxyHost:{}", ftpProxyHost);
            logger.info("ftp.proxyPort:{}", ftpProxyPort);
            logger.info("ftp.nonProxyHosts:{}", ftpNonProxyHosts);
            prop.setProperty("ftp.proxyHost", ftpProxyHost);
            prop.setProperty("ftp.proxyPort", ftpProxyPort);
            prop.setProperty("ftp.nonProxyHosts", ftpNonProxyHosts);
        }
        if (!StringUtil.isEmpty(socksProxyHost)) {
            logger.info("socks.proxyHost:{}", socksProxyHost);
            logger.info("socks.proxyPort:{}", socksProxyPort);
            prop.setProperty("socksProxyHost", socksProxyHost);
            prop.setProperty("socksProxyPort", socksProxyPort);
        }
        if (!StringUtil.isEmpty(proxyUsername)) {
            logger.info("proxy.username:{}", proxyUsername);
            final String username = proxyUsername;
            final String password = proxyPassword;
            Authenticator.setDefault(new Authenticator() {
                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }

            });
        }
        //set Authorized
        String swaggerHeaders = get("swagger.apis.headers");
        if(!StringUtil.isEmpty(swaggerHeaders)){
            String[] headersArr = swaggerHeaders.split(";");
            WebContext.JSM_AUTHORIZATION = headersArr[0].split("\\|")[0];
        }
    }

    private static void loadPropMap() {
        String propFile = "project.properties";
        logger.info("load:{} ", propFile);
        Properties properties = PropUtil.getProperties(propFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propMap.put((String) entry.getKey(), (String) entry.getValue());
        }
        propFile = "app.properties";
        logger.info("load:{} ", propFile);
        properties = PropUtil.getProperties(propFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propMap.put((String) entry.getKey(), (String) entry.getValue());
        }
        logger.info("props:{}", StringUtil.toJson(propMap));
    }

}
