package com.jsmframe.base;

import java.util.Date;

import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.exception.BaseException;
import com.jsmframe.exception.FailedException;
import com.jsmframe.exception.NotFoundException;
import com.jsmframe.pair.Pair;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.utils.ExceptionUtil;
import com.jsmframe.utils.JsmFrameUtil;
import com.jsmframe.utils.ResponseUtil;
import org.slf4j.Logger;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

import com.jsmframe.interceptor.MyDateEditor;
import com.jsmframe.utils.LogUtil;

@RestController
public abstract class BaseRest {
    protected Logger logger = LogUtil.log(getClass());

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, new MyDateEditor());
    }

    @ExceptionHandler(Exception.class)
    public RestResp globalExceptionHandler(Exception e) {
        logger.error("globalExceptionHandler error.", e);
        return JsmFrameUtil.dealException(e);
    }

    protected void failed(String errorMsg) {
        ExceptionUtil.failed(errorMsg);
    }

    protected void failed(Pair errorPair) {
        ExceptionUtil.failed(errorPair);
    }

    protected void failed(Pair errorPair, String errorMsg) {
        ExceptionUtil.failed(errorPair, errorMsg);
    }

    protected void notFound(String errorMsg) {
        ExceptionUtil.notFound(errorMsg);
    }

    protected void notFound(Pair errorPair) {
        ExceptionUtil.notFound(errorPair);
    }

    protected void notFound(Pair errorPair, String errorMsg) {
        ExceptionUtil.notFound(errorPair, errorMsg);
    }

    protected void info(Pair errorPair) {
        ExceptionUtil.info(errorPair);
    }

    protected void info(String errorMsg) {
        ExceptionUtil.info(errorMsg);
    }

    protected void info(Pair errorPair, String errorMsg) {
        ExceptionUtil.info(errorPair, errorMsg);
    }

}
