
package com.jsmframe.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;

import javax.persistence.Transient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * entity基类.
 */
public class BaseModel implements ValidateModel {

    private static final long serialVersionUID = 1L;

    protected Logger logger = LogUtil.log(getClass());

    @Transient
    @JSONField(serialize = false)
    @ApiParam(hidden = true)
    public Object snapshot;

    @FieldAnn(required = true, name = "id", comments = "记录ID")
    public Long id;

    public String toJSONString() {
        return StringUtil.toJson(this);
    }

    @ApiParam(hidden = true)
    public void createSnapshot() {
        if (this.snapshot == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this);

                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.snapshot = objectInputStream.readObject();
            } catch (Exception e) {
                logger.error("create snapshot error!", e);
            }
        }
    }

    @ApiParam(hidden = true)
    public Object getSnapshot() {
        return snapshot;
    }

    @ApiParam(hidden = true)
    public void setSnapshot(Object snapshot) {
        this.snapshot = snapshot;
    }
}
