package com.jsmframe.utils;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;

public class XmlUtil {
	private static Log log = LogFactory.getLog(XmlUtil.class);
	
	/**
	 * 
	 * @param xmlStr
	 * @return
	 */
	public static Document parseText(String xmlStr){
		try {
			return DocumentHelper.parseText(xmlStr);
		} catch (DocumentException e) {
			log.error("parse xml error:"+xmlStr, e);
			return null;
		}
	}
	
	/**
	 * 
	 * @param document
	 * @return
	 */
	public static String toXml(Document document){
		
		return document.asXML();
	}

	public static Document createNewDoc(){
		return createNewDoc("utf8");
	}
	public static Document createNewDoc(String encode){
		Document doc = DocumentHelper.createDocument();
		doc.setXMLEncoding(encode);
		return doc;
	}
	public static Document loadXml(String xmlPath){
		SAXReader sax = new SAXReader();
		try {
			return sax.read(new File(xmlPath));
		} catch (DocumentException e) {
			log.error("loadXml erorr:"+xmlPath, e);
			return null;
		}
	}
	public static Document loadClassPathXml(String xmlPath){
		SAXReader sax = new SAXReader();
		try {
//			return sax.read(FileUtil.getResource(xmlPath));
			return sax.read(ClassLoader.getSystemResourceAsStream(xmlPath));
		} catch (DocumentException e) {
			log.error("loadXml erorr:"+xmlPath, e);
			return null;
		}
	}
	
	public static void main(String[] args){
		System.out.println(createNewDoc().asXML());
	}
}
