package com.jsmframe.utils;

import org.slf4j.Logger;

public class IpUtil {
	
	private static Logger logger = LogUtil.log(IpUtil.class);
	
	private String ENABLE_CMD = "iptables -D INPUT -s %s -j DROP";
	private String DISABLE_CMD = "iptables -I INPUT -s %s -j DROP";
	
	/**
	 * 禁IP
	 * @param ip
	 * @return
	 */
	public boolean disableIp(String ip) {
		if(!SystemUtil.IS_OS_UNIX) {
			logger.error("not unix ,can't run shell.");
			return false;
		}
		if(!StringUtil.isIpv4(ip)) {
			logger.error("is not a ip:{}",ip);
			return false;
		}
		
		String cmd = String.format(DISABLE_CMD, ip);
		ShellUtil.exec(cmd);
		return true;
	} 
	
	/**
	 * 解禁IP
	 * @param ip
	 * @return
	 */
	public boolean enableIp(String ip) {
		if(!SystemUtil.IS_OS_UNIX) {
			logger.error("not unix ,can't run shell.");
			return false;
		}
		if(!StringUtil.isIpv4(ip)) {
			logger.error("is not a ip:{}",ip);
			return false;
		}
		
		String cmd = String.format(ENABLE_CMD, ip);
		ShellUtil.exec(cmd);
		return true;
	}
	
	
	
	

}
