package com.jsmframe.utils;

import com.alibaba.fastjson.JSON;
import com.jsmframe.context.WebContext;
import com.jsmframe.http.HttpClientProcessor;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.*;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

import javax.net.ssl.SSLContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;


public class HttpClientUtil {
    private static Logger logger = LogUtil.log(HttpClientUtil.class);
    private static String DEFAULT_CHARSET = "utf8";

    public static String get(String url) {
        return get(null, url);
    }

    public static String getN(String url, int tryTimes) {
        String res = get(url);
        if (tryTimes > 0 && res == null) {
            return getN(url, tryTimes - 1);
        } else {
            return res;
        }
    }

    public static String get(HttpHost proxyHost, String url) {
        logger.info("get url:" + url);
        String res = null;
        CloseableHttpClient httpclient = (proxyHost == null ? createClient() : createClient(proxyHost));
        try {
            HttpGet httpGet = new HttpGet(url);
            setExtraHeaders(httpGet);
            CloseableHttpResponse response1 = httpclient.execute(httpGet);
            try {
                logger.info("get url status:" + response1.getStatusLine());
                res = EntityUtils.toString(response1.getEntity(), DEFAULT_CHARSET);
            } catch (Exception e) {
                logger.error("http get read error:" + url, e);
            } finally {
                response1.close();
            }
        } catch (Exception e) {
            logger.error("http get error:" + url, e);
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                logger.error("httpclient close error!", e);
            }
        }

        return res;
    }

    /**
     * List <NameValuePair> nvps = new ArrayList <NameValuePair>();
     * nvps.add(new BasicNameValuePair("username", "vip"));
     * nvps.add(new BasicNameValuePair("password", "secret"));
     *
     * @param url
     * @param nvps
     * @return
     */
    public static String post(String url, List<NameValuePair> nvps) {
        return post(null, url, nvps);
    }

    public static String postN(String url, List<NameValuePair> nvps, int tryTimes) {
        String res = post(url,nvps);
        if (tryTimes > 0 && res == null) {
            return postN(url,nvps,tryTimes - 1);
        } else {
            return res;
        }
    }

    public static String post(HttpHost proxyHost, String url, List<NameValuePair> nvps) {
        logger.info("post url:" + url);
        logger.debug("nvps:" + JSON.toJSONString(nvps));
        String res = null;
        CloseableHttpClient httpclient = (proxyHost == null ? createClient() : createClient(proxyHost));
        try {
            HttpPost httpPost = new HttpPost(url);
            setExtraHeaders(httpPost);
            httpPost.setEntity(new UrlEncodedFormEntity(nvps, "utf8"));
            CloseableHttpResponse response2 = httpclient.execute(httpPost);
            try {
                logger.info(response2.getStatusLine().toString());
                res = EntityUtils.toString(response2.getEntity(), DEFAULT_CHARSET);
            } catch (Exception e) {
                logger.error("http post read error:" + url, e);
            } finally {
                response2.close();
            }
        } catch (Exception e) {
            logger.error("http post error:" + url, e);
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                logger.error("httpclient close error!", e);
            }
        }

        return res;
    }

    public static String post(String url, Object data) {
        if (data instanceof String) {
            return post(null, url, (String) data);
        } else {
            return post(null, url, JSON.toJSONString(data));
        }
    }

    public static String postN(String url, Object data, int tryTimes) {
        String res = post(url,data);
        if (tryTimes > 0 && res == null) {
            return postN(url,data,tryTimes - 1);
        } else {
            return res;
        }
    }

    public static String post(String url, String strEntity) {
        return post(null, url, strEntity);
    }

    public static String postN(String url, String strEntity, int tryTimes) {
        String res = post(url,strEntity);
        if (tryTimes > 0 && res == null) {
            return postN(url,strEntity,tryTimes - 1);
        } else {
            return res;
        }
    }

    public static String post(HttpHost proxyHost, String url, String strEntity) {
        logger.info("post url:" + url);
        logger.debug("strEntity:" + JSON.toJSONString(strEntity));
        String res = null;
        CloseableHttpClient httpclient = (proxyHost == null ? createClient() : createClient(proxyHost));
        try {
            HttpPost httpPost = new HttpPost(url);
            setExtraHeaders(httpPost);
            StringEntity entity = new StringEntity(strEntity, DEFAULT_CHARSET);//解决中文乱码问题
            entity.setContentEncoding("utf8");
            entity.setContentType("application/json");
            httpPost.setEntity(entity);
            CloseableHttpResponse response2 = httpclient.execute(httpPost);

            try {
                logger.info(response2.getStatusLine().toString());
                res = EntityUtils.toString(response2.getEntity());
            } catch (Exception e) {
                logger.error("http post read error:" + url, e);
            } finally {
                response2.close();
            }
        } catch (Exception e) {
            logger.error("http post error:" + url, e);
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                logger.error("httpclient close error!", e);
            }
        }
        return res;
    }

    public static String put(String url, Object data) {
        if (data instanceof String) {
            return put(null,url, (String) data);
        } else {
            return put(null,url, JSON.toJSONString(data));
        }
    }

    public static String putN(String url, Object data, int tryTimes) {
        String res = put(url,data);
        if (tryTimes > 0 && res == null) {
            return putN(url,data,tryTimes - 1);
        } else {
            return res;
        }
    }

    public static String put(HttpHost proxyHost,String url, String strEntity) {
        logger.info("put url:" + url);
        logger.debug("strEntity:" + JSON.toJSONString(strEntity));
        String res = null;
        CloseableHttpClient httpclient = (proxyHost == null ? createClient() : createClient(proxyHost));
        try {
            HttpPut httpPut = new HttpPut(url);
            setExtraHeaders(httpPut);
            StringEntity entity = new StringEntity(strEntity, DEFAULT_CHARSET);//解决中文乱码问题
            entity.setContentEncoding("utf8");
            entity.setContentType("application/json");
            httpPut.setEntity(entity);
            CloseableHttpResponse response2 = httpclient.execute(httpPut);

            try {
                logger.info(response2.getStatusLine().toString());
                res = EntityUtils.toString(response2.getEntity());
            } catch (Exception e) {
                logger.error("http put read error:" + url, e);
            } finally {
                response2.close();
            }
        } catch (Exception e) {
            logger.error("http put error:" + url, e);
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                logger.error("httpclient close error!", e);
            }
        }
        return res;
    }

    public static String delete(String url) {
        return delete(null,url);
    }

    public static String deleteN(String url, int tryTimes) {
        String res = delete(url);
        if (tryTimes > 0 && res == null) {
            return deleteN(url, tryTimes - 1);
        } else {
            return res;
        }
    }

    public static String delete(HttpHost proxyHost,String url) {
        logger.info("delete url:" + url);
        String res = null;
        CloseableHttpClient httpclient = (proxyHost == null ? createClient() : createClient(proxyHost));
        try {
            HttpDelete httpDelete = new HttpDelete(url);
//			httpPost = proxyHttpPost(httpPost);
            CloseableHttpResponse response2 = httpclient.execute(httpDelete);
            setExtraHeaders(httpDelete);
            try {
                logger.info(response2.getStatusLine().toString());
                res = EntityUtils.toString(response2.getEntity(), DEFAULT_CHARSET);
            } catch (Exception e) {
                logger.error("http delete read error:" + url, e);
            } finally {
                response2.close();
            }
        } catch (Exception e) {
            logger.error("http delete error:" + url, e);
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                logger.error("httpclient close error!", e);
            }
        }
        return res;
    }

    public static String getImage(String url, String savePath, List<Header> headers) {
        logger.info("getImage url:" + url);
        CloseableHttpClient httpclient = createClient();
        CloseableHttpResponse response = null;
        FileOutputStream output = null;
        InputStream fis = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            setExtraHeaders(httpGet);
            response = httpclient.execute(httpGet);
            logger.info("get image url:" + response.getStatusLine());
            output = new FileOutputStream(savePath);
            //得到网络资源的字节数组,并写入文件  
            fis = response.getEntity().getContent();
            byte b[] = new byte[1024];
            int j = 0;
            while ((j = fis.read(b)) != -1) {
                output.write(b, 0, j);
            }
            return savePath;

        } catch (Exception e) {
            logger.error("http get error:" + url, e);
            return null;
        } finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (output != null) {
                    output.flush();
                    output.close();
                }
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            } catch (IOException e) {
                logger.error("httpclient getImage close error!", e);
            }
        }
    }

    public static String getFile(String url, String savePath) {

        return getFile(url, savePath, null);
    }

    public static String getFile(String url, String savePath, List<Header> headers) {
        logger.info("getFile url:" + url);
        CloseableHttpClient httpclient = createClient();
        CloseableHttpResponse response = null;
        FileOutputStream output = null;
        InputStream fis = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            setExtraHeaders(httpGet);
            response = httpclient.execute(httpGet);
            logger.info("get file url:" + response.getStatusLine());
            output = new FileOutputStream(savePath);
            //得到网络资源的字节数组,并写入文件
            fis = response.getEntity().getContent();
            byte b[] = new byte[1024];
            int j = 0;
            while ((j = fis.read(b)) != -1) {
                output.write(b, 0, j);
            }
            return savePath;

        } catch (Exception e) {
            logger.error("http get error:" + url, e);
            return null;
        } finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (output != null) {
                    output.flush();
                    output.close();
                }
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            } catch (IOException e) {
                logger.error("httpclient getFile close error!", e);
            }
        }
    }

    public static void get(String url, List<Header> headers, HttpClientProcessor processor) {
        logger.info("get url:" + url);
        CloseableHttpClient httpclient = createClient();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                httpGet.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            setExtraHeaders(httpGet);
            response = httpclient.execute(httpGet);
            logger.info("get url:" + response.getStatusLine());
            processor.process(response);
        } catch (Exception e) {
            logger.error("http get error:" + url, e);
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            } catch (IOException e) {
                logger.error("httpclient get close error!", e);
            }
        }
    }

    public static String postFile(String url, String filePath) {
        return postFile(url, "file", filePath);
    }

    public static String postFile(String url, String name, String filePath) {
        logger.info("postFile url:{},filePath:{}", url, filePath);
        String res = null;
        CloseableHttpClient httpclient = createClient();
        try {
            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(5000)
                    .setConnectionRequestTimeout(1000)
                    .setSocketTimeout(600000)// 10mins
                    .build();
            HttpPost httpPost = new HttpPost(url);
            setExtraHeaders(httpPost);
            httpPost.setConfig(requestConfig);
            FileBody bin = new FileBody(new File(filePath));
            long len = bin.getContentLength();
            logger.info("postFile size:" + len / 1024 + "KB");
            HttpEntity reqEntity = MultipartEntityBuilder.create()
                    .addBinaryBody(name, new File(filePath))
                    .setCharset(Charset.forName("utf8"))
                    .setMode(HttpMultipartMode.BROWSER_COMPATIBLE)
                    .build();
            httpPost.setEntity(reqEntity);
            CloseableHttpResponse response2 = httpclient.execute(httpPost);

            try {
                logger.info(response2.getStatusLine().toString());
                res = EntityUtils.toString(response2.getEntity());
                logger.info("postFile res:" + res);
            } catch (Exception e) {
                logger.error("http postFile read error:" + url, e);
            } finally {
                response2.close();
            }
        } catch (Exception e) {
            logger.error("http postFile error:" + url, e);
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                logger.error("httpclient close error!", e);
            }
        }
        return res;
    }

    private static HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler() {
        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    };

    private static void setExtraHeaders(HttpRequestBase httpEntity){

        String requestId = WebContext.getRequestId();
        String at = WebContext.getRequestAt();
        String ht = WebContext.getRequestHt();
        String token = WebContext.getRequestToken();
        String authorization = WebContext.getRequestAuthorization();
        if(!StringUtil.isEmpty(requestId)){
            httpEntity.setHeader(WebContext.JSM_REQ_ID,requestId);
        }
        if(!StringUtil.isEmpty(at)){
            httpEntity.setHeader(WebContext.JSM_AT,at);
        }
        if(!StringUtil.isEmpty(ht)){
            httpEntity.setHeader(WebContext.JSM_HT,ht);
        }
        if(!StringUtil.isEmpty(token)){
            httpEntity.setHeader(WebContext.JSM_TOKEN,token);
        }
        if(!StringUtil.isEmpty(authorization)){
            httpEntity.setHeader(WebContext.JSM_AUTHORIZATION,authorization);
        }
    }

    /**
     * 创建一个SSL信任所有证书的httpClient对象
     *
     * @return
     */
    private static CloseableHttpClient createClient() {
        return createClient(null);
    }

    private static CloseableHttpClient createClient(HttpHost proxyHost) {
        SSLConnectionSocketFactory sslcsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(new TrustStrategy() {
                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            })
                    .build();
//			  AllowAllHostnameVerifier: 这种方式不对主机名进行验证，验证功能被关闭，是个空操作(域名验证)
//			  DefaultHostnameVerifier:默认实现，遵从RFC2818。主机名必须符合指定证书上任意备选名称。 
//		      NoopHostnameVerifier:该主机名验证器本质上会关闭主机名验证。它接受任何有效的和符合目标主机的SSL会
            sslcsf = new SSLConnectionSocketFactory(sslContext, new NoopHostnameVerifier());
        } catch (Exception e) {
            logger.error("create ssl socket factory error!", e);
        }

        HttpClientBuilder hcb = HttpClientBuilder.create();
//        		.setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy())  
//	            .setRedirectStrategy(new DefaultRedirectStrategy());
//	            .setDefaultRequestConfig(requestConfig)  
//              .setDefaultCookieStore(cookieStore)
//              .setDefaultHeaders(this.headers);
        if (proxyHost != null) {
            hcb.setProxy(proxyHost);
        }
        if (sslcsf != null) {
            hcb.setSSLSocketFactory(sslcsf);
        }
        hcb.setRetryHandler(myRetryHandler);
        return hcb.build();
    }


}

class MySocksConnectionSocketFactory implements ConnectionSocketFactory {

    @Override
    public Socket createSocket(final HttpContext context) throws IOException {
        InetSocketAddress socksaddr = (InetSocketAddress) context.getAttribute("socks.address");
        // socket代理
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
        return new Socket(proxy);
    }

    @Override
    public Socket connectSocket(
            final int connectTimeout,
            final Socket socket,
            final HttpHost host,
            final InetSocketAddress remoteAddress,
            final InetSocketAddress localAddress,
            final HttpContext context) throws IOException, ConnectTimeoutException {
        Socket sock;
        if (socket != null) {
            sock = socket;
        } else {
            sock = createSocket(context);
        }
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            sock.connect(remoteAddress, connectTimeout);
        } catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException(ex, host, remoteAddress.getAddress());
        }
        return sock;
    }

}