package com.jsmframe.utils;

import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.slf4j.Logger;
import org.springframework.util.ResourceUtils;

import com.jsmframe.exception.BaseException;


/**
 * @author longzl / @createOn 2010-9-3
 * @desc
 */
public class FileUtil {
    private static Logger logger = LogUtil.log(FileUtil.class);

    public static File getResource(String filename) {
        try {
            return ResourceUtils.getFile("classpath:" + filename);
        } catch (FileNotFoundException e) {
            logger.warn("file {0} not found", filename);
            throw new BaseException("file not found：" + filename, e);
        }
    }

    public static File createNewFile(String filePath) {
        filePath = filePath.replace('\\', '/').trim();
        new File(filePath.substring(0, filePath.lastIndexOf('/'))).mkdirs();
        return new File(filePath);
    }

    public static File getFile(String filename) {
        return new File(filename);
    }

    public static boolean zip(String filePath, String zipFileName) {
        logger.info("zip dir:{} to {}", filePath, zipFileName);
        //创建zip输出流
        ZipOutputStream out = null;
        BufferedOutputStream bos = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFileName));
            bos = new BufferedOutputStream(out);
            File sourceFile = new File(filePath);
            compress(out,bos,sourceFile);
        } catch (Exception e) {
            logger.error("zip error!", e);
            return false;
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (Exception e) {
                    logger.error("zip close bos error!", e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (Exception e) {
                    logger.error("zip close out error!", e);
                }
            }
        }
        return true;
    }

    private static void compress(ZipOutputStream out, BufferedOutputStream bos, File sourceFile) throws Exception {
        String fileName = sourceFile.getName();
        if (sourceFile.isDirectory()) {
            File[] flist = sourceFile.listFiles();
            if (flist.length == 0) {
                out.putNextEntry(new ZipEntry(fileName + "/"));
            } else {
                for (File file:flist) {
                    compress(out, bos, file);
                }
            }
        } else {
            out.putNextEntry(new ZipEntry(fileName));
            FileInputStream fos = null;
            BufferedInputStream bis = null;
            try {
                fos = new FileInputStream(sourceFile);
                bis = new BufferedInputStream(fos);
                int len;
                while ((len = bis.read()) != -1) {
                    bos.write(len);
                }
            }catch (Exception e){
                logger.error("compress error!",e);
            }finally {
                if(bis != null){
                    bis.close();
                }
                if(fos != null){
                    fos.close();
                }
            }
        }
    }
}
