package com.jsmframe.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.jsmframe.context.AppContext;
import org.springframework.stereotype.Service;

import com.jsmframe.dao.mapper.DbMapper;
import com.jsmframe.base.BaseService;
import com.jsmframe.dao.model.CreateTableInfo;
import com.jsmframe.dao.model.FieldInfo;
import com.jsmframe.utils.FtlUtil;

@Service
public class GenService extends BaseService {

	@Resource
	private DbMapper dbMapper;

	public void genAll() {
		List<String> tableNameList = dbMapper.showTables();
		for (String tableName : tableNameList) {
			gen(tableName,false);
		}
	}

	public void gen(String tableName) {
		gen(tableName,false);
	}

	public void gen(String tableName,boolean override) {
		String baseJavaDir = AppContext.get("gen.base.java.dir");
		String modelPackageName = AppContext.get("gen.model.package.name");
		String mapperPackageName = AppContext.get("gen.mapper.package.name");
		String servicePackageName = AppContext.get("gen.service.package.name");
		String mapperXmlDirPath = AppContext.get("gen.mapper.xml.dir");
		logger.info("baseJavaDir:{}",baseJavaDir);
		logger.info("modelPackageName:{}",modelPackageName);
		logger.info("mapperPackageName:{}",mapperPackageName);
		logger.info("mapperXmlDirPath:{}",mapperXmlDirPath);
		logger.info("servicePackageName:{}",servicePackageName);

//		String classpathDir = this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
		String mapperFtl = "mapper.ftl";
		String mapperXmlFtl = "mapperXml.ftl";
		String modelFtl = "model.ftl";
		String serviceFtl = "service.ftl";
//		logger.info("classpathDir:{}",classpathDir);
		logger.info("mapperFtl:{}",mapperFtl);
		logger.info("mapperXmlFtl:{}",mapperXmlFtl);
		logger.info("modelFtl:{}",modelFtl);
		logger.info("serviceFtl:{}",serviceFtl);

		String modelDirPath = baseJavaDir + modelPackageName.replace(".", "\\");
		String mapperDirPath = baseJavaDir + mapperPackageName.replace(".", "\\");
		String serviceDirPath = baseJavaDir + servicePackageName.replace(".", "\\");

		File modelDir = new File(modelDirPath);
		if (!modelDir.exists()) {
			logger.info("mkdir:{}", modelDir);
			modelDir.mkdirs();
		}
		
		File mapperDir = new File(mapperDirPath);
		if (!mapperDir.exists()) {
			logger.info("mkdir:{}", mapperDir);
			mapperDir.mkdirs();
		}
		
		File mapperXmlDir = new File(mapperXmlDirPath);
		if (!mapperXmlDir.exists()) {
			logger.info("mkdir:{}", mapperXmlDir);
			mapperXmlDir.mkdirs();
		}

		File serviceDir = new File(serviceDirPath);
		if (!serviceDir.exists()) {
			logger.info("mkdir:{}", serviceDir);
			serviceDir.mkdirs();
		}

		String className = tableNameToModelName(tableName);

		String modelFileName = modelDirPath + "\\" + className + ".java";
		String mapperFileName = mapperDirPath + "\\" + className + "Mapper.java";
		String mapperXmlFileName = mapperXmlDir + "\\" + className + "Mapper.xml";
		String serviceFileName = serviceDir + "\\" + className + "Service.java";

		Map<String, Object> datas = new HashMap<String, Object>();
		datas.put("modelPackageName", modelPackageName);
		datas.put("mapperPackageName", mapperPackageName);
		datas.put("servicePackageName", servicePackageName);
		datas.put("tableName", tableName);
		datas.put("className", className);
		List<FieldInfo> fieldList = getTabelFieldInfo(tableName, datas);
		datas.put("fieldList", fieldList);

		//gen model java
		String modelStr = FtlUtil.build(this.getClass(),"/META-INF/ftl/",datas, modelFtl);
		boolean modelRes = writeFile(modelStr,modelFileName,override);
		logger.info("createModel:{} res:{}",modelFileName,modelRes);

		//gen mapper java
		String mapperStr = FtlUtil.build(this.getClass(),"/META-INF/ftl/",datas, mapperFtl);
		boolean mapperRes = writeFile(mapperStr,mapperFileName,override);
		logger.info("createMapper:{} res:{}",mapperFileName,mapperRes);

		//gen mapperXml java
		String mapperXmlStr = FtlUtil.build(this.getClass(),"/META-INF/ftl/",datas, mapperXmlFtl);
		boolean mapperXmlRes = writeFile(mapperXmlStr,mapperXmlFileName,override);
		logger.info("createMapperXml:{} res:{}",mapperXmlFileName,mapperXmlRes);

		//gen service java
		String serviceStr = FtlUtil.build(this.getClass(),"/META-INF/ftl/",datas, serviceFtl);
		boolean serviceRes = writeFile(serviceStr,serviceFileName,override);
		logger.info("createService:{} res:{}",serviceFileName,serviceRes);
	}

	/**
	 * @param text
	 * @param filePath
	 * @return
	 */
	private boolean writeFile(String text,String filePath,boolean override){
		
		File modelFile = new File(filePath);
		if (!override && modelFile.exists()) {
			logger.warn("file:{} exists, ignore! override:{}",filePath,override);
			return false;
		}
		
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(filePath);
			fos.write(text.getBytes());
			return true;
		} catch (Exception e) {
			logger.error("", e);
			return false;
		} finally {
			try {
				if (fos != null) {
					fos.close();
				}
			} catch (IOException e) {
				logger.error("", e);
			}
		}
	}

	private List<FieldInfo> getTabelFieldInfo(String tableName, Map<String, Object> datas) {
		logger.info("getTabelFieldInfo:{}", tableName);
		List<FieldInfo> list = new ArrayList<FieldInfo>();
		List<CreateTableInfo> res = dbMapper.showCreateTable(tableName);
		if (res.size() > 0) {
			String createInfo = res.get(0).CreateTable;
			String[] lineArr = createInfo.split("\\n");
			logger.debug(createInfo);
			for (int i = 1; i < lineArr.length - 2; i++) {
				String[] arr = lineArr[i].trim().replaceAll("\\s+", " ").replace("NOT NULL", "NOT_NULL")
						.replace("`", "").split(" ");
				if (arr.length < 4) {
					logger.warn("ignore line:{}", lineArr[i]);
					continue;
				}
				FieldInfo info = new FieldInfo();
				info.fieldName = arr[0];
				if (info.fieldName.equals("id")) {
					logger.warn("id line ignore:{}", lineArr[i]);
					continue;
				}
				info.fieldType = mysqlTypeToJavaType(arr[1]);
				if (info.fieldType == null) {
					logger.warn("fieldType not found , ignore line:{}", lineArr[i]);
					continue;
				}
				info.defaultVal = arr[3];
				if (arr.length > 5) {
					info.comments = lineArr[i].substring(lineArr[i].indexOf("'") + 1);
					info.comments = info.comments.substring(0, info.comments.length() - 2);
				}
				if (info.fieldType.equals("Date")) {
					datas.put("hasDate", true);
				}
				list.add(info);
			}
		}
		return list;
	}

	private String mysqlTypeToJavaType(String mysqlType) {
		if (mysqlType.startsWith("int(") || mysqlType.startsWith("integer")) {
			return "Integer";
		}
		if (mysqlType.startsWith("varchar(") || mysqlType.contains("text")) {
			return "String";
		}
		if (mysqlType.startsWith("bigint(")) {
			return "Long";
		}
		if (mysqlType.startsWith("bit(")) {
			return "Boolean";
		}
		if (mysqlType.startsWith("float")) {
			return "Float";
		}
		if (mysqlType.startsWith("double")) {
			return "Double";
		}
		if (mysqlType.startsWith("tinyint(")) {
			return "Short";
		}
		if (mysqlType.startsWith("date") || mysqlType.startsWith("timestamp")) {
			return "Date";
		}
		return null;
	}

	private String tableNameToModelName(String tableName) {
		String clazzName = tableName;
		if (clazzName.endsWith("_t")) {
			clazzName = clazzName.substring(0, clazzName.length() - 2);
		}
		StringBuilder sb = new StringBuilder();
		boolean toUpper = true;
		for (int i = 0; i < clazzName.length(); i++) {
			char c = clazzName.charAt(i);
			if (c == '_') {
				toUpper = true;
				continue;
			}
			sb.append(toUpper ? Character.toUpperCase(c) : c);
			if (toUpper) {
				toUpper = false;
			}
		}
		return sb.toString();
	}

}
