package com.jsmframe.prop;

import com.jsmframe.utils.BlowFishUtil;
import com.jsmframe.utils.EncryptUtil;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class JsmPropertyDecoder extends PropertyPlaceholderConfigurer {
    @Override
    protected String convertProperty(String propertyName, String propertyValue) {

        //如果在加密属性名单中发现该属性
        if (propertyName.startsWith("enc.")) {
            String decryptValue = BlowFishUtil.dec(propertyValue);
            return decryptValue;
        } else {
            return propertyValue;
        }

    }
}