package com.jsmframe.mybatis;

import java.util.regex.Matcher;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;

public class OracleDialect extends AbstractDialect {

	@Override
	public String concatCountSql(String sql) {
		StringBuffer sb = new StringBuffer("select count(*) from ");
		Matcher fromMatcher = fromPattern.matcher(sql);
		int beginIndex = 0;
		if (fromMatcher.find()) {
			beginIndex = fromMatcher.end();
		}
		Matcher orderByMatcher = orderByPattern.matcher(sql);
		int lastIndex = sql.lastIndexOf(")");
		if (lastIndex != -1 && orderByMatcher.find(lastIndex)) {
			sb.append(sql.substring(beginIndex, orderByMatcher.start()));
		} else {
			sb.append(sql.substring(beginIndex));
		}
		return sb.toString();
	}

	@Override
	public String concatPageSql(String sql, int startRow, int pageSize) {
		StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
        sqlBuilder.append("SELECT * FROM ( ");
        sqlBuilder.append(" SELECT TMP_PAGE.*, ROWNUM ROW_ID FROM ( ");
        sqlBuilder.append(sql);
        sqlBuilder.append(" ) TMP_PAGE WHERE ROWNUM <= ");
        sqlBuilder.append(startRow);
        sqlBuilder.append(" ) WHERE ROW_ID > ");
        sqlBuilder.append(startRow + pageSize);
        return sqlBuilder.toString();
	}

	public SqlSource getSqlSource(BoundSql boundSql) {

		return new MySqlSource(boundSql);

	}

	public class MySqlSource implements SqlSource {
		BoundSql boundSql;

		public MySqlSource(BoundSql boundSql) {
			this.boundSql = boundSql;
		}

		@Override
		public BoundSql getBoundSql(Object parameterObject) {
			return boundSql;
		}
	}

}
