package com.jsmframe.log4j;

import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.PatternParser;

public class JsmPatternLayout extends PatternLayout {
    public JsmPatternLayout(String pattern){
        super(pattern);
    }

    public JsmPatternLayout(){
        this(DEFAULT_CONVERSION_PATTERN);
    }
    /**
     * 重写createPatternParser方法，返回PatternParser的子类
     */
    @Override
    protected PatternParser createPatternParser(String pattern) {
        return new JsmPatternParser(pattern == null ? DEFAULT_CONVERSION_PATTERN : pattern);
    }
}
