package com.jsmframe.interceptor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.jsmframe.context.ProjectContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.jedis.JedisCmd;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.utils.DateUtil;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.util.NestedServletException;

import com.jsmframe.context.WebContext;
import com.jsmframe.exception.BaseException;
import com.jsmframe.utils.LogUtil;
import redis.clients.jedis.ShardedJedis;

/**
 * @author longzl / @createOn 2010-6-25
 * @desc
 */
public class JsmFilter extends OncePerRequestFilter {
    private Logger logger = LogUtil.log(this.getClass());

    private String encoding;

    private boolean forceEncoding = false;

    private JedisService jedisService;

    private Boolean apistat = ProjectContext.getAsBoolean("api.stat");

    private String apistatKey = "api_stat";

    private Integer apistatExpire = ProjectContext.getAsInteger("api.stat.expire");//seconds

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setForceEncoding(boolean forceEncoding) {
        this.forceEncoding = forceEncoding;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain fc)
            throws IOException {
        WebContext.setRequest(request);
        WebContext.setResponse(response);
        String reqMethod = request.getMethod();
        final long now = System.currentTimeMillis();
        final long pid = Thread.currentThread().getId();
        final String uri = String.format("%s;%s;%s;%s;%s", now,pid, reqMethod, request.getRequestURI(), WebContext.getRemoteIp(request));
        logger.debug(uri);
        long startTime = System.nanoTime();
        if(jedisService == null){
            jedisService = SpringContext.getBean(JedisService.class);
        }
        if (apistat != null && apistat == true && jedisService != null) {
            if (apistatExpire == null) {
                apistatExpire = 3600;
            }
            jedisService.expire(apistatKey,apistatExpire);
            jedisService.exec(new JedisCmd<Long>() {
                @Override
                public Long run(ShardedJedis shardedJedis) {
                    return shardedJedis.zadd(apistatKey,now,uri);
                }
            });
        }

        if ((this.encoding != null)
                && (((this.forceEncoding) || (request.getCharacterEncoding() == null)))) {
            request.setCharacterEncoding(this.encoding);
            if (this.forceEncoding) {
                response.setCharacterEncoding(this.encoding);
            }
        }

        try {
            if (reqMethod.equals(RequestMethod.OPTIONS.name())) {
                String error = "request method not support.";
                logger.warn("request method not support {}", reqMethod);
                WebContext.toErrorPage(error);
            } else {
                logger.debug("before fc.doFilter");
                fc.doFilter(request, response);// FileUploadBase$SizeLimitExceededException
                logger.debug("after fc.doFilter");
            }
        } catch (NestedServletException nse) {
            String error = "访问" + request.getRequestURL().toString() + "出错！";
            logger.error(error, nse);
            if (nse.getCause() instanceof BaseException) {
                WebContext.toErrorPage(nse.getCause().getMessage());
            } else if (nse.getCause() instanceof MaxUploadSizeExceededException) {
                WebContext.toErrorPage("文件大小超过限制！");
            } else {
                WebContext.toErrorPage("系统出错！");
            }
            logger.error(error, nse);
        } catch (Exception e) {
            String error = "访问" + request.getRequestURL().toString() + "出错！";
            logger.error(error, e);
            WebContext.toErrorPage(error);
        }

        if (apistat != null && apistat == true && jedisService != null) {
            final long spendTime = System.nanoTime() - startTime;
            jedisService.exec(new JedisCmd<Long>() {
                @Override
                public Long run(ShardedJedis shardedJedis) {
                    shardedJedis.zrem(apistatKey,uri);
                    return shardedJedis.zadd(apistatKey,now,uri+";"+spendTime);
                }
            });
        }

        WebContext.removeRequest();
        WebContext.removeResponse();
    }

}
