package com.jsmframe.base;

import javax.transaction.Transactional;

import org.quartz.Job;
import org.slf4j.Logger;

import com.jsmframe.utils.LogUtil;

public abstract class BaseJob<T> implements Job {
	
	protected Logger logger = LogUtil.log(getClass());
	
	public T doRun(){
		try {
			return run();
		} catch (Exception e) {
			return null;
		}
	}

	@Transactional(rollbackOn = {Exception.class})
	public abstract T run();
	
}
