/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;

public class XmlUtil {
    private static Log log = LogFactory.getLog(XmlUtil.class);

    public static Document parseText(String string) {
        try {
            return DocumentHelper.parseText((String)string);
        }
        catch (DocumentException documentException) {
            log.error((Object)("parse xml error:" + string), (Throwable)documentException);
            return null;
        }
    }

    public static String toXml(Document document) {
        return document.asXML();
    }

    public static Document createNewDoc() {
        return XmlUtil.createNewDoc("utf8");
    }

    public static Document createNewDoc(String string) {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding(string);
        return document;
    }

    public static Document loadXml(String string) {
        SAXReader sAXReader = new SAXReader();
        try {
            return sAXReader.read(new File(string));
        }
        catch (DocumentException documentException) {
            log.error((Object)("loadXml erorr:" + string), (Throwable)documentException);
            return null;
        }
    }

    public static Document loadClassPathXml(String string) {
        SAXReader sAXReader = new SAXReader();
        try {
            return sAXReader.read(ClassLoader.getSystemResourceAsStream(string));
        }
        catch (DocumentException documentException) {
            log.error((Object)("loadXml erorr:" + string), (Throwable)documentException);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(XmlUtil.createNewDoc().asXML());
    }
}

