/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.context.WebContext;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.LogUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class WebUtil {
    private static Logger logger = LogUtil.log(WebUtil.class);

    public static String genToken(String string) {
        return EncryptUtil.md5(string + Math.random() + System.nanoTime());
    }

    public static boolean hasPermissions(String string) {
        List<String> list = WebContext.currentPermissions();
        if (list == null) {
            logger.error("user have no permission!");
            return false;
        }
        if (list.contains("SUPER_ADMIN")) {
            return true;
        }
        Boolean bl = false;
        String string2 = null;
        try {
            SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
            StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
            standardEvaluationContext.setVariable("permissions", list);
            string2 = WebUtil.createExpression(string);
            bl = (Boolean)spelExpressionParser.parseExpression(string2).getValue((EvaluationContext)standardEvaluationContext, Boolean.class);
        }
        catch (Exception exception) {
            logger.error("permissionsStr {},elsStr {} ", (Object)string, string2);
            logger.error("permissionVerify error!permissionsStr", (Throwable)exception);
        }
        return bl;
    }

    private static String createExpression(String string) {
        String string2 = "([0-9a-zA-Z_-]+)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        String string3 = matcher.replaceAll("#permissions?.contains('$1')");
        return string3;
    }

    public static void main(String[] stringArray) {
        String string = "1002|BOOK_MANAGEMENT_BREAK|BOOK_MANAGEMENT_SHORT|BOOK_MANAGEMENT_SUPER_SHORT|BOOK_MANAGEMENT_SERVICE";
        String string2 = WebUtil.createExpression(string);
        System.out.println(string2);
    }
}

