/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.annotation.EscapeType;
import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.annotation.FieldType;
import com.jsmframe.base.ValidateCallback;
import com.jsmframe.base.ValidateModel;
import com.jsmframe.context.ProjectContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.utils.BeanUtil;
import com.jsmframe.utils.HtmlUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ValidateUtil {
    private static Logger logger = LogUtil.log(ValidateUtil.class);
    private static Map<String, ValidateCallback> cbCache = new HashMap<String, ValidateCallback>();

    public static String validate(Object object) {
        Field[] fieldArray;
        String string = null;
        for (Field field : fieldArray = object.getClass().getDeclaredFields()) {
            String string2;
            boolean bl;
            Object object2;
            Object object3;
            Object object4;
            String string3 = field.getName();
            FieldAnn fieldAnn = field.getAnnotation(FieldAnn.class);
            if (fieldAnn == null || (object4 = ValidateUtil.getFieldValue(field, object)) == null && !fieldAnn.required()) continue;
            if (ValidateModel.class.isAssignableFrom(field.getType())) {
                if (fieldAnn.required() && object4 == null) {
                    string = SpringContext.getMessage("valid.required", string3);
                    return string;
                }
                if (object4 == null || StringUtil.isEmpty((String)(object3 = ValidateUtil.validate(object4)))) continue;
                object3 = string3 + "." + (String)object3;
                return object3;
            }
            if (List.class.isAssignableFrom(field.getType())) {
                object3 = (List)ValidateUtil.getFieldValue(field, object);
                if (fieldAnn.required() && (object3 == null || object3.isEmpty())) {
                    string = SpringContext.getMessage("valid.required", string3);
                    return string;
                }
                if (object3 == null) continue;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    String string4;
                    Object e = object2.next();
                    if (e == null || !ValidateModel.class.isAssignableFrom(e.getClass()) || StringUtil.isEmpty(string4 = ValidateUtil.validate(e))) continue;
                    string4 = string3 + "." + string4;
                    return string4;
                }
                continue;
            }
            if (fieldAnn.required() && StringUtil.isEmpty(object4)) {
                string = SpringContext.getMessage("valid.required", string3);
                break;
            }
            object3 = fieldAnn.type();
            if (!StringUtil.isEmpty(object4) && !((Enum)object3).equals((Object)FieldType.ALL)) {
                if (FieldType.NUMBER.equals(object3) && !StringUtil.isNumber(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.EN_NUMBER.equals(object3) && !StringUtil.isEnNum(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.CHINESE.equals(object3) && !StringUtil.isChinese(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.DATE.equals(object3) && !StringUtil.isDate(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.DATE_TIME.equals(object3) && !StringUtil.isDateTime(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.EMAIL.equals(object3) && !StringUtil.isEmail(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.ID_CARD.equals(object3) && !StringUtil.isIdcard(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.IPV4.equals(object3) && !StringUtil.isIpv4(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.MOB_NO.equals(object3) && !StringUtil.isMobNo(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.TEL_NO.equals(object3) && !StringUtil.isTelNo(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.MONEY.equals(object3) && !StringUtil.isMoney(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.URL.equals(object3) && !StringUtil.isUrl(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
                if (FieldType.BANK_CARD.equals(object3) && !StringUtil.isBankCard(object4.toString())) {
                    string = SpringContext.getMessage("valid.mustbe", string3, ((FieldType)((Object)object3)).t());
                    break;
                }
            }
            if (!StringUtil.isEmpty((String)(object2 = fieldAnn.regex())) && object4 instanceof String && !((String)object4).matches((String)object2)) {
                String string5 = SpringContext.getMessage(fieldAnn.message(), new Object[0]);
                string = SpringContext.getMessage("valid.regexLimit", string3, string5);
                break;
            }
            int n = fieldAnn.minLen();
            if (n != -1 && object4 instanceof String && ((String)object4).length() < n) {
                string = SpringContext.getMessage("valid.minLenLimit", string3, n);
                break;
            }
            int n2 = fieldAnn.maxLen();
            if (n2 != -1 && object4 instanceof String && ((String)object4).length() > n2) {
                string = SpringContext.getMessage("valid.maxLenLimit", string3, n2);
                break;
            }
            String string6 = fieldAnn.el();
            if (!StringUtil.isEmpty(string6) && !(bl = ValidateUtil.exeEl(string6, object))) {
                string2 = SpringContext.getMessage(fieldAnn.message(), new Object[0]);
                string = SpringContext.getMessage("valid.regexLimit", string3, string2);
                break;
            }
            String string7 = fieldAnn.cb();
            if (!StringUtil.isEmpty(string7) && !StringUtil.isEmpty(string2 = ValidateUtil.exeCb(string7, BeanUtil.getFieldValue(field, object), (ValidateModel)object))) {
                string = SpringContext.getMessage("valid.regexLimit", string3, string2);
                break;
            }
            if (!(object4 instanceof String)) continue;
            string2 = (String)object4;
            EscapeType escapeType = fieldAnn.escape();
            if (EscapeType.ALL.equals((Object)escapeType)) {
                ValidateUtil.setFieldValue(field, object, HtmlUtil.filter(string2));
                continue;
            }
            if (EscapeType.CSS.equals((Object)escapeType)) {
                ValidateUtil.setFieldValue(field, object, HtmlUtil.cssFilter(string2));
                continue;
            }
            if (EscapeType.JS.equals((Object)escapeType)) {
                ValidateUtil.setFieldValue(field, object, HtmlUtil.jsFilter(string2));
                continue;
            }
            if (!EscapeType.HTML.equals((Object)escapeType)) continue;
            ValidateUtil.setFieldValue(field, object, HtmlUtil.htmlFilter(string2));
        }
        return string;
    }

    private static String exeCb(String string, Object object, ValidateModel validateModel) {
        try {
            ValidateCallback validateCallback;
            String string2 = ProjectContext.get("validator.package");
            if (!string.contains(".")) {
                if (StringUtil.isEmpty(string2)) {
                    logger.warn("validator.package not config in project.properties");
                } else {
                    string = string2 + "." + string;
                }
            }
            if ((validateCallback = cbCache.get(string)) == null) {
                Class<?> clazz = Class.forName(string);
                if (!ValidateCallback.class.isAssignableFrom(clazz)) {
                    logger.error("cb class is not implements ValidateCallback, ignore.");
                    return null;
                }
                validateCallback = (ValidateCallback)clazz.newInstance();
                cbCache.put(string, validateCallback);
            }
            return validateCallback.exe(object, validateModel);
        }
        catch (Exception exception) {
            logger.error("validata cb class can't load." + string, (Throwable)exception);
            return null;
        }
    }

    public static boolean exeEl(String string, Object object) {
        SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        standardEvaluationContext.setVariable("vm", object);
        standardEvaluationContext.setVariable("session", (Object)WebContext.currentSession());
        standardEvaluationContext.setVariable("request", (Object)WebContext.getRequest());
        String string2 = ValidateUtil.createExpression(string, object);
        return (Boolean)spelExpressionParser.parseExpression(string2).getValue((EvaluationContext)standardEvaluationContext, Boolean.class);
    }

    private static String createExpression(String string, Object object) {
        Pattern pattern = Pattern.compile("#\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(string);
        HashSet<String> hashSet = new HashSet<String>();
        while (matcher.find()) {
            hashSet.add(matcher.group(1));
        }
        for (String string2 : hashSet) {
            String string3 = (String)BeanUtil.getFieldValue(string2, object);
            if (StringUtil.isEmpty(string3)) continue;
            string = string.replaceAll("#\\{" + string2 + "\\}", string3);
        }
        return string;
    }

    private static Object getFieldValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            logger.error("getFieldValue error!", (Throwable)exception);
            return null;
        }
    }

    private static void setFieldValue(Field field, Object object, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (Exception exception) {
            logger.error("getFieldValue error!", (Throwable)exception);
        }
    }
}

