/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class ValidCodeUtil {
    private static Logger log = LogUtil.log(ValidCodeUtil.class);
    private Random random = new Random();
    private String randAll = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    private String randNumber = "0123456789";
    private String name = "validCode";
    private int width = 80;
    private int height = 26;
    private int lineSize = 40;
    private int num = 4;
    private boolean numberOnly = true;
    private StringBuilder validCode = new StringBuilder();

    public String getValidCode() {
        return this.validCode.toString();
    }

    public ValidCodeUtil(String string, int n, int n2, int n3) {
        if (!StringUtil.isEmpty(string)) {
            this.name = string;
        }
        if (n != 0) {
            this.width = n;
        }
        if (n2 != 0) {
            this.height = n2;
        }
        if (n3 != 0) {
            this.num = n3;
        }
    }

    public ValidCodeUtil(String string, int n, int n2, int n3, boolean bl) {
        this(string, n, n2, n3);
        this.numberOnly = bl;
    }

    private Font getFont() {
        return new Font("Fixedsys", 1, 18);
    }

    private Color getRandColor(int n, int n2) {
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        int n3 = n + this.random.nextInt(n2 - n - 16);
        int n4 = n + this.random.nextInt(n2 - n - 14);
        int n5 = n + this.random.nextInt(n2 - n - 18);
        return new Color(n3, n4, n5);
    }

    public BufferedImage getImage(HttpSession httpSession) {
        int n;
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 4);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setFont(new Font("Times New Roman", 0, 18));
        graphics.setColor(this.getRandColor(110, 133));
        for (n = 0; n <= this.lineSize; ++n) {
            this.drowLine(graphics);
        }
        for (n = 1; n <= this.num; ++n) {
            this.drowString(graphics, n);
        }
        httpSession.removeAttribute(this.name);
        httpSession.setAttribute(this.name, (Object)this.getValidCode());
        log.debug("validCode:" + this.getValidCode());
        graphics.dispose();
        return bufferedImage;
    }

    public BufferedImage getImage() {
        int n;
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 4);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setFont(new Font("Times New Roman", 0, 18));
        graphics.setColor(this.getRandColor(110, 133));
        for (n = 0; n <= this.lineSize; ++n) {
            this.drowLine(graphics);
        }
        for (n = 1; n <= this.num; ++n) {
            this.drowString(graphics, n);
        }
        log.debug("validCode:" + this.getValidCode());
        graphics.dispose();
        return bufferedImage;
    }

    private void drowString(Graphics graphics, int n) {
        graphics.setFont(this.getFont());
        graphics.setColor(new Color(this.random.nextInt(101), this.random.nextInt(111), this.random.nextInt(121)));
        String string = this.getRandomChar();
        this.validCode.append(string);
        graphics.translate(this.random.nextInt(3), this.random.nextInt(3));
        graphics.drawString(string, 13 * n, 16);
    }

    private void drowLine(Graphics graphics) {
        int n = this.random.nextInt(this.width);
        int n2 = this.random.nextInt(this.height);
        int n3 = this.random.nextInt(13);
        int n4 = this.random.nextInt(15);
        graphics.drawLine(n, n2, n + n3, n2 + n4);
    }

    private String getRandomChar() {
        String string = this.numberOnly ? this.randNumber : this.randAll;
        int n = this.random.nextInt(string.length());
        return String.valueOf(string.charAt(n));
    }
}

