/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.context.SpringContext;
import com.jsmframe.utils.LogUtil;
import org.slf4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class TransactionUtil {
    private static Logger logger = LogUtil.log(TransactionUtil.class);
    private static ThreadLocal<TransactionStatus> transTL = new ThreadLocal();

    public static PlatformTransactionManager getTransactionManager() {
        return (PlatformTransactionManager)SpringContext.getBean("transactionManager");
    }

    public static PlatformTransactionManager getTransactionManager(String string) {
        return (PlatformTransactionManager)SpringContext.getBean(string);
    }

    public static void setTransactionStatus(TransactionStatus transactionStatus) {
        transTL.set(transactionStatus);
    }

    public static TransactionStatus getTransactionStatus() {
        return transTL.get();
    }

    public static void removeTransactionStatus() {
        transTL.remove();
    }

    public static void setRollbackOnly() {
        TransactionStatus transactionStatus = transTL.get();
        if (transactionStatus == null) {
            logger.error("setRollbackOnly transactionStatus is null.");
            return;
        }
        if (transactionStatus.isCompleted()) {
            logger.error("setRollbackOnly transactionStatus is completed.");
            return;
        }
        transactionStatus.setRollbackOnly();
    }

    public static void commit() {
        PlatformTransactionManager platformTransactionManager = TransactionUtil.getTransactionManager();
        TransactionStatus transactionStatus = transTL.get();
        if (transactionStatus == null) {
            logger.error("commit transactionStatus is null.");
            return;
        }
        if (transactionStatus.isCompleted()) {
            logger.error("commit transactionStatus is completed.");
            return;
        }
        platformTransactionManager.commit(transactionStatus);
    }
}

