/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import java.io.File;

public class SystemUtil {
    public static final String AWT_TOOLKIT = SystemUtil.getSystemProperty("awt.toolkit");
    public static final String FILE_ENCODING = SystemUtil.getSystemProperty("file.encoding");
    public static final String FILE_SEPARATOR = SystemUtil.getSystemProperty("file.separator");
    public static final String JAVA_AWT_FONTS = SystemUtil.getSystemProperty("java.awt.fonts");
    public static final String JAVA_AWT_GRAPHICSENV = SystemUtil.getSystemProperty("java.awt.graphicsenv");
    public static final String JAVA_AWT_HEADLESS = SystemUtil.getSystemProperty("java.awt.headless");
    public static final String JAVA_AWT_PRINTERJOB = SystemUtil.getSystemProperty("java.awt.printerjob");
    public static final String JAVA_CLASS_PATH = SystemUtil.getSystemProperty("java.class.path");
    public static final String JAVA_CLASS_VERSION = SystemUtil.getSystemProperty("java.class.version");
    public static final String JAVA_COMPILER = SystemUtil.getSystemProperty("java.compiler");
    public static final String JAVA_ENDORSED_DIRS = SystemUtil.getSystemProperty("java.endorsed.dirs");
    public static final String JAVA_EXT_DIRS = SystemUtil.getSystemProperty("java.ext.dirs");
    public static final String JAVA_HOME = SystemUtil.getSystemProperty("java.home");
    public static final String JAVA_IO_TMPDIR = SystemUtil.getSystemProperty("java.io.tmpdir");
    public static final String JAVA_LIBRARY_PATH = SystemUtil.getSystemProperty("java.library.path");
    public static final String JAVA_RUNTIME_NAME = SystemUtil.getSystemProperty("java.runtime.name");
    public static final String JAVA_RUNTIME_VERSION = SystemUtil.getSystemProperty("java.runtime.version");
    public static final String JAVA_SPECIFICATION_NAME = SystemUtil.getSystemProperty("java.specification.name");
    public static final String JAVA_SPECIFICATION_VENDOR = SystemUtil.getSystemProperty("java.specification.vendor");
    public static final String JAVA_SPECIFICATION_VERSION = SystemUtil.getSystemProperty("java.specification.version");
    public static final String JAVA_UTIL_PREFS_PREFERENCES_FACTORY = SystemUtil.getSystemProperty("java.util.prefs.PreferencesFactory");
    public static final String JAVA_VENDOR = SystemUtil.getSystemProperty("java.vendor");
    public static final String JAVA_VENDOR_URL = SystemUtil.getSystemProperty("java.vendor.url");
    public static final String JAVA_VERSION = SystemUtil.getSystemProperty("java.version");
    public static final String JAVA_VM_INFO = SystemUtil.getSystemProperty("java.vm.info");
    public static final String JAVA_VM_NAME = SystemUtil.getSystemProperty("java.vm.name");
    public static final String JAVA_VM_SPECIFICATION_NAME = SystemUtil.getSystemProperty("java.vm.specification.name");
    public static final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtil.getSystemProperty("java.vm.specification.vendor");
    public static final String JAVA_VM_SPECIFICATION_VERSION = SystemUtil.getSystemProperty("java.vm.specification.version");
    public static final String JAVA_VM_VENDOR = SystemUtil.getSystemProperty("java.vm.vendor");
    public static final String JAVA_VM_VERSION = SystemUtil.getSystemProperty("java.vm.version");
    public static final String LINE_SEPARATOR = SystemUtil.getSystemProperty("line.separator");
    public static final String OS_ARCH = SystemUtil.getSystemProperty("os.arch");
    public static final String OS_NAME = SystemUtil.getSystemProperty("os.name");
    public static final String OS_VERSION = SystemUtil.getSystemProperty("os.version");
    public static final String PATH_SEPARATOR = SystemUtil.getSystemProperty("path.separator");
    public static final String USER_COUNTRY = SystemUtil.getSystemProperty("user.country") == null ? SystemUtil.getSystemProperty("user.region") : SystemUtil.getSystemProperty("user.country");
    public static final String USER_DIR = SystemUtil.getSystemProperty("user.dir");
    public static final String USER_HOME = SystemUtil.getSystemProperty("user.home");
    public static final String USER_LANGUAGE = SystemUtil.getSystemProperty("user.language");
    public static final String USER_NAME = SystemUtil.getSystemProperty("user.name");
    public static final String USER_TIMEZONE = SystemUtil.getSystemProperty("user.timezone");
    public static final String JAVA_VERSION_TRIMMED = SystemUtil.getJavaVersionTrimmed();
    public static final float JAVA_VERSION_FLOAT = SystemUtil.getJavaVersionAsFloat();
    public static final int JAVA_VERSION_INT = SystemUtil.getJavaVersionAsInt();
    public static final boolean IS_JAVA_1_1 = SystemUtil.getJavaVersionMatches("1.1");
    public static final boolean IS_JAVA_1_2 = SystemUtil.getJavaVersionMatches("1.2");
    public static final boolean IS_JAVA_1_3 = SystemUtil.getJavaVersionMatches("1.3");
    public static final boolean IS_JAVA_1_4 = SystemUtil.getJavaVersionMatches("1.4");
    public static final boolean IS_JAVA_1_5 = SystemUtil.getJavaVersionMatches("1.5");
    public static final boolean IS_OS_AIX = SystemUtil.getOSMatches("AIX");
    public static final boolean IS_OS_HP_UX = SystemUtil.getOSMatches("HP-UX");
    public static final boolean IS_OS_IRIX = SystemUtil.getOSMatches("Irix");
    public static final boolean IS_OS_LINUX = SystemUtil.getOSMatches("Linux") || SystemUtil.getOSMatches("LINUX");
    public static final boolean IS_OS_MAC = SystemUtil.getOSMatches("Mac");
    public static final boolean IS_OS_MAC_OSX = SystemUtil.getOSMatches("Mac OS X");
    public static final boolean IS_OS_OS2 = SystemUtil.getOSMatches("OS/2");
    public static final boolean IS_OS_SOLARIS = SystemUtil.getOSMatches("Solaris");
    public static final boolean IS_OS_SUN_OS = SystemUtil.getOSMatches("SunOS");
    public static final boolean IS_OS_UNIX = IS_OS_AIX || IS_OS_HP_UX || IS_OS_IRIX || IS_OS_LINUX || IS_OS_MAC_OSX || IS_OS_SOLARIS || IS_OS_SUN_OS;
    public static final boolean IS_OS_WINDOWS = SystemUtil.getOSMatches("Windows");
    public static final boolean IS_OS_WINDOWS_2000 = SystemUtil.getOSMatches("Windows", "5.0");
    public static final boolean IS_OS_WINDOWS_95 = SystemUtil.getOSMatches("Windows 9", "4.0");
    public static final boolean IS_OS_WINDOWS_98 = SystemUtil.getOSMatches("Windows 9", "4.1");
    public static final boolean IS_OS_WINDOWS_ME = SystemUtil.getOSMatches("Windows", "4.9");
    public static final boolean IS_OS_WINDOWS_NT = SystemUtil.getOSMatches("Windows NT");
    public static final boolean IS_OS_WINDOWS_XP = SystemUtil.getOSMatches("Windows", "5.1");

    public static File getJavaHome() {
        return new File(System.getProperty("java.home"));
    }

    public static File getJavaIoTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    @Deprecated
    public static float getJavaVersion() {
        return JAVA_VERSION_FLOAT;
    }

    private static float getJavaVersionAsFloat() {
        if (JAVA_VERSION_TRIMMED == null) {
            return 0.0f;
        }
        String string = JAVA_VERSION_TRIMMED.substring(0, 3);
        if (JAVA_VERSION_TRIMMED.length() >= 5) {
            string = string + JAVA_VERSION_TRIMMED.substring(4, 5);
        }
        return Float.parseFloat(string);
    }

    private static int getJavaVersionAsInt() {
        if (JAVA_VERSION_TRIMMED == null) {
            return 0;
        }
        String string = JAVA_VERSION_TRIMMED.substring(0, 1);
        string = string + JAVA_VERSION_TRIMMED.substring(2, 3);
        string = JAVA_VERSION_TRIMMED.length() >= 5 ? string + JAVA_VERSION_TRIMMED.substring(4, 5) : string + "0";
        return Integer.parseInt(string);
    }

    private static boolean getJavaVersionMatches(String string) {
        if (JAVA_VERSION_TRIMMED == null) {
            return false;
        }
        return JAVA_VERSION_TRIMMED.startsWith(string);
    }

    private static String getJavaVersionTrimmed() {
        if (JAVA_VERSION != null) {
            for (int i = 0; i < JAVA_VERSION.length(); ++i) {
                char c = JAVA_VERSION.charAt(i);
                if (c < '0' || c > '9') continue;
                return JAVA_VERSION.substring(i);
            }
        }
        return null;
    }

    private static boolean getOSMatches(String string) {
        if (OS_NAME == null) {
            return false;
        }
        return OS_NAME.startsWith(string);
    }

    private static boolean getOSMatches(String string, String string2) {
        if (OS_NAME == null || OS_VERSION == null) {
            return false;
        }
        return OS_NAME.startsWith(string) && OS_VERSION.startsWith(string2);
    }

    private static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a SecurityException reading the system property '" + string + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static boolean isJavaAwtHeadless() {
        return JAVA_AWT_HEADLESS != null ? JAVA_AWT_HEADLESS.equals(Boolean.TRUE.toString()) : false;
    }

    public static boolean isJavaVersionAtLeast(float f) {
        return JAVA_VERSION_FLOAT >= f;
    }

    public static boolean isJavaVersionAtLeast(int n) {
        return JAVA_VERSION_INT >= n;
    }
}

