/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.alibaba.fastjson.JSON;
import com.jsmframe.context.ProjectContext;
import com.jsmframe.utils.LogUtil;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class StringUtil {
    private static Logger logger = LogUtil.log(StringUtil.class);
    private static final String CONSTS_STR = "QWERTYUPASDFGHJKZXCVBNM1234567890qwertyupasdfghjkzxcvbnm";

    public static String substr(String string, int n, int n2) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        if (string.length() <= n) {
            return null;
        }
        int n3 = n + n2;
        if (n3 > string.length()) {
            n3 = string.length();
        }
        return string.substring(n, n3);
    }

    public static String extract(String string, String string2) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String extractNumber(String string) {
        return StringUtil.extract(ProjectContext.get("regex.extract.number"), string);
    }

    public static Integer extractInteger(String string) {
        String string2 = StringUtil.extractNumber(string);
        if (!StringUtil.isEmpty(string2)) {
            return Integer.valueOf(string2);
        }
        return null;
    }

    public static Float extractFloat(String string) {
        String string2 = StringUtil.extractNumber(string);
        if (!StringUtil.isEmpty(string2)) {
            return Float.valueOf(string2);
        }
        return null;
    }

    public static Double extractDouble(String string) {
        String string2 = StringUtil.extractNumber(string);
        if (!StringUtil.isEmpty(string2)) {
            return Double.valueOf(string2);
        }
        return null;
    }

    public static String iso2utf(String string) {
        String string2 = StringUtils.stripToEmpty((String)string);
        try {
            string2 = new String(string2.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("iso2utf error!", (Throwable)unsupportedEncodingException);
        }
        return string2;
    }

    public static String trim(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String toJson(Object object) {
        try {
            return JSON.toJSONString((Object)object);
        }
        catch (Exception exception) {
            logger.error("toJson error!", (Throwable)exception);
            return null;
        }
    }

    public static String toUtf8String(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            byte[] byArray;
            char c = string.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                stringBuffer.append(c);
                continue;
            }
            try {
                byArray = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception exception) {
                System.out.println(exception);
                byArray = new byte[]{};
            }
            for (int j = 0; j < byArray.length; ++j) {
                int n = byArray[j];
                if (n < 0) {
                    n += 256;
                }
                stringBuffer.append("%" + Integer.toHexString(n).toUpperCase());
            }
        }
        return stringBuffer.toString();
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        return StringUtil.isEmpty(object.toString());
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return "".equals(string = string.trim());
    }

    public static Integer toInteger(Object object) {
        return StringUtil.toInteger(StringUtil.toString(object), 0);
    }

    public static Integer toInteger(String string) {
        return StringUtil.toInteger(string, 0);
    }

    public static Integer toInteger(String string, Integer n) {
        try {
            return Integer.valueOf(StringUtil.trim(string));
        }
        catch (Exception exception) {
            logger.error("toInteger error, use defaultVal:{}", (Object)n);
            return n;
        }
    }

    public static Float toFloat(String string) {
        return StringUtil.toFloat(string, Float.valueOf(0.0f));
    }

    public static Float toFloat(String string, Float f) {
        try {
            return Float.valueOf(StringUtil.trim(string));
        }
        catch (Exception exception) {
            logger.error("toFloat error, use defaultVal:{}", (Object)f);
            return f;
        }
    }

    public static Long toLong(String string) {
        return StringUtil.toLong(string, 0L);
    }

    public static Long toLong(String string, Long l) {
        try {
            return Long.valueOf(string);
        }
        catch (Exception exception) {
            logger.error("toLong error, use defaultVal:{}", (Object)l);
            return l;
        }
    }

    public static Double toDouble(String string) {
        return StringUtil.toDouble(string, 0.0);
    }

    public static Double toDouble(String string, Double d) {
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            logger.error("toDouble error, use defaultVal:{}", (Object)d);
            return d;
        }
    }

    public static String toString(Object object) {
        return object == null ? "" : object.toString().trim();
    }

    public static boolean notNullAndEquls(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return object.toString().equals(object2.toString());
    }

    public static boolean isEmail(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.email"));
        }
        return false;
    }

    public static boolean isUrl(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.url"));
        }
        return false;
    }

    public static boolean isIdcard(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.idcard"));
        }
        return false;
    }

    public static boolean isTelNo(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.telno"));
        }
        return false;
    }

    public static boolean isMobNo(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.mobno"));
        }
        return false;
    }

    public static boolean isIpv4(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.ipv4"));
        }
        return false;
    }

    public static boolean isDate(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.date"));
        }
        return false;
    }

    public static boolean isDateTime(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.datetime"));
        }
        return false;
    }

    public static boolean isChinese(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.chinese"));
        }
        return false;
    }

    public static boolean isNumber(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.number"));
        }
        return false;
    }

    public static boolean isMoney(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.money"));
        }
        return false;
    }

    public static boolean isBankCard(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.bankcard"));
        }
        return false;
    }

    public static boolean isEnNum(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.ennum"));
        }
        return false;
    }

    public static boolean isAccount(String string) {
        if (string != null) {
            return string.matches(ProjectContext.get("regex.valid.account"));
        }
        return false;
    }

    public static boolean isEquals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static Long yuanToFen(Double d) {
        return Double.valueOf(d * 100.0).longValue();
    }

    public static Double fenToYuan(Long l) {
        return (double)l.longValue() / 100.0;
    }

    public static String fill(Object object, int n) {
        String string = object.toString();
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append("0");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static int getByteLength(String string) {
        if (string == null) {
            return 0;
        }
        return string.getBytes().length;
    }

    public static String normalizeSQL(String string) {
        if (string == null) {
            return string;
        }
        return string.trim().replaceAll("\\s+", " ");
    }

    public static String trimCRLF(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("(\r|\n|\r\n)", " ");
    }

    public static String trimTab(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("(\t+)", " ");
    }

    public static String genRandomString(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(CONSTS_STR.charAt(random.nextInt(CONSTS_STR.length())));
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(StringUtil.genRandomString(5));
    }
}

