/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class ReflectionUtil {
    private static Logger logger = LogUtil.log(ReflectionUtil.class);

    private static Field getDeclaredField(Object object, String string) {
        Assert.notNull((Object)object, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)string, (String)"fieldName");
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static Method getDeclaredMethod(Object object, String string, Class<?>[] classArray) {
        Assert.notNull((Object)object, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)string, (String)"methodName");
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Object getFieldValue(Object object, String string) {
        Field field = ReflectionUtil.getDeclaredField(object, string);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + string + "] on target [" + object + "]");
        }
        ReflectionUtil.makeAccessible(field);
        Object object2 = null;
        try {
            object2 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)illegalAccessException.getMessage());
        }
        return object2;
    }

    public static void setFieldValue(Object object, String string, Object object2) {
        Field field = ReflectionUtil.getDeclaredField(object, string);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + string + "] on target [" + object + "]");
        }
        ReflectionUtil.makeAccessible(field);
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)illegalAccessException.getMessage());
        }
    }

    public static Object invokeMethod(Object object, String string, Class<?>[] classArray, Object[] objectArray) {
        Method method = ReflectionUtil.getDeclaredMethod(object, string, classArray);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + string + "] on target [" + object + "]");
        }
        method.setAccessible(true);
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(exception);
        }
    }

    public static Object invokeGetterMethod(Object object, String string) {
        String string2 = "get" + StringUtils.capitalize((String)string);
        return ReflectionUtil.invokeMethod(object, string2, new Class[0], new Object[0]);
    }

    public static void invokeSetterMethod(Object object, String string, Class<?> clazz, Object object2) {
        String string2 = "set" + StringUtils.capitalize((String)string);
        Class<?> clazz2 = clazz != null ? clazz : object2.getClass();
        ReflectionUtil.invokeMethod(object, string2, new Class[]{clazz2}, new Object[]{object2});
    }

    public static void invokeSetterMethod(Object object, String string, Object object2) {
        ReflectionUtil.invokeSetterMethod(object, string, null, object2);
    }

    private static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getSuperClassGenricType(Class<T> clazz) {
        return ReflectionUtil.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int n) {
        Type type = clazz.getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        if (n >= typeArray.length || n < 0) {
            logger.warn("Index: " + n + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + typeArray.length);
            return Object.class;
        }
        if (!(typeArray[n] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)typeArray[n];
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception exception) {
        if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException || exception instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.", exception);
        }
        if (exception instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException("Unexpected Checked Exception.", exception);
    }
}

