/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;

public class QuartzUtil {
    private static Logger logger = LogUtil.log(QuartzUtil.class);
    private static SchedulerFactory schedulerFactory = new StdSchedulerFactory();

    public static boolean addJob(String string, String string2, String string3, String string4, Class clazz, String string5) {
        boolean bl = true;
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            JobDetail jobDetail = JobBuilder.newJob((Class)clazz).withIdentity(string, string2).build();
            if (scheduler.checkExists(jobDetail.getKey())) {
                logger.error("job key exists!");
                return false;
            }
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(string3, string4);
            triggerBuilder.startNow();
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string5));
            CronTrigger cronTrigger = (CronTrigger)triggerBuilder.build();
            scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            if (!scheduler.isShutdown()) {
                scheduler.start();
            }
        }
        catch (Exception exception) {
            logger.error("addJob error!", (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public static boolean modifyJobTime(String string, String string2, String string3, String string4, String string5) {
        boolean bl = true;
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)string3, (String)string4);
            CronTrigger cronTrigger = (CronTrigger)scheduler.getTrigger(triggerKey);
            if (cronTrigger == null) {
                return false;
            }
            String string6 = cronTrigger.getCronExpression();
            if (!string6.equalsIgnoreCase(string5)) {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                triggerBuilder.withIdentity(string3, string4);
                triggerBuilder.startNow();
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string5));
                cronTrigger = (CronTrigger)triggerBuilder.build();
                scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
            }
        }
        catch (Exception exception) {
            logger.error("modifyJobTime error!", (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public static boolean removeJob(String string, String string2, String string3, String string4) {
        boolean bl = true;
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)string3, (String)string4);
            scheduler.pauseTrigger(triggerKey);
            scheduler.unscheduleJob(triggerKey);
            scheduler.deleteJob(JobKey.jobKey((String)string, (String)string2));
        }
        catch (Exception exception) {
            logger.error("removeJob error!", (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public static boolean startJobs() {
        boolean bl = true;
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.start();
        }
        catch (Exception exception) {
            logger.error("startJobs error!", (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public static boolean shutdownJobs() {
        boolean bl = true;
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();
            if (!scheduler.isShutdown()) {
                scheduler.shutdown();
            }
        }
        catch (Exception exception) {
            logger.error("shutdownJobs error!", (Throwable)exception);
            bl = false;
        }
        return bl;
    }
}

