/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.ShellUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.SystemUtil;
import org.slf4j.Logger;

public class IpUtil {
    private static Logger logger = LogUtil.log(IpUtil.class);
    private String ENABLE_CMD = "iptables -D INPUT -s %s -j DROP";
    private String DISABLE_CMD = "iptables -I INPUT -s %s -j DROP";

    public boolean disableIp(String string) {
        if (!SystemUtil.IS_OS_UNIX) {
            logger.error("not unix ,can't run shell.");
            return false;
        }
        if (!StringUtil.isIpv4(string)) {
            logger.error("is not a ip:{}", (Object)string);
            return false;
        }
        String string2 = String.format(this.DISABLE_CMD, string);
        ShellUtil.exec(string2);
        return true;
    }

    public boolean enableIp(String string) {
        if (!SystemUtil.IS_OS_UNIX) {
            logger.error("not unix ,can't run shell.");
            return false;
        }
        if (!StringUtil.isIpv4(string)) {
            logger.error("is not a ip:{}", (Object)string);
            return false;
        }
        String string2 = String.format(this.ENABLE_CMD, string);
        ShellUtil.exec(string2);
        return true;
    }
}

