/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.LogUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;

public class ImageUtil {
    private static Logger logger = LogUtil.log(ImageUtil.class);
    public static final String IMAGE_JPEG = "jpg";
    public static final String IMAGE_PNG = "png";
    public static final String IMAGE_GIF = "gif";
    private static final String JPG_HEX = "ff";
    private static final String PNG_HEX = "89";

    public static BufferedImage resizeImage(String string, String string2, int n, int n2) throws IOException {
        return ImageUtil.resizeImage(ImageIO.read(new File(string)), string2, n, n2);
    }

    public static BufferedImage resizeImage(BufferedImage bufferedImage, String string, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        float f = (float)n3 / (float)n4;
        if (n3 > n || n4 > n2) {
            if ((float)dimension.width / (float)dimension.height > f) {
                dimension.width = (int)Math.ceil((float)dimension.height * f);
            } else {
                dimension.height = (int)Math.ceil((float)dimension.width / f);
            }
            n3 = dimension.width;
            n4 = dimension.height;
        }
        return ImageUtil.createHeadlessSmoothBufferedImage(bufferedImage, string, n3, n4);
    }

    public static boolean saveImage(BufferedImage bufferedImage, String string, String string2) throws IOException {
        return ImageIO.write((RenderedImage)bufferedImage, IMAGE_JPEG.equals(string2) ? IMAGE_JPEG : IMAGE_PNG, new File(string));
    }

    public static void saveCompressedImage(BufferedImage bufferedImage, String string, String string2) throws IOException {
        if (IMAGE_PNG.equalsIgnoreCase(string2)) {
            throw new UnsupportedOperationException("PNG compression not implemented");
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(IMAGE_JPEG);
        ImageWriter imageWriter = iterator.next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
        imageWriter.setOutput(imageOutputStream);
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
        jPEGImageWriteParam.setCompressionMode(2);
        jPEGImageWriteParam.setCompressionQuality(0.7f);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
    }

    public static void compressImage(String string, float f) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        file.delete();
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(IMAGE_JPEG);
        ImageWriter imageWriter = iterator.next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
        imageWriter.setOutput(imageOutputStream);
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
        jPEGImageWriteParam.setCompressionMode(2);
        jPEGImageWriteParam.setCompressionQuality(f);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
    }

    public static String getSuffix(String string, String string2) {
        if (string.contains(".")) {
            return string.substring(string.lastIndexOf(".") + 1);
        }
        return string2;
    }

    public static BufferedImage createHeadlessBufferedImage(BufferedImage bufferedImage, String string, int n, int n2) {
        int n3 = 0;
        n3 = IMAGE_PNG.equalsIgnoreCase(string) && ImageUtil.hasAlpha(bufferedImage) ? 2 : 1;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage2.setRGB(j, i, bufferedImage.getRGB(j * bufferedImage.getWidth() / n, i * bufferedImage.getHeight() / n2));
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage createHeadlessSmoothBufferedImage(BufferedImage bufferedImage, String string, int n, int n2) {
        int n3 = 0;
        n3 = IMAGE_PNG.equalsIgnoreCase(string) && ImageUtil.hasAlpha(bufferedImage) ? 2 : 1;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        double d = (double)n / (double)bufferedImage.getWidth();
        double d2 = (double)n2 / (double)bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            int n4 = i * bufferedImage.getHeight() / bufferedImage2.getHeight();
            double d3 = ImageUtil.scale(i, d2) - (double)n4;
            for (int j = 0; j < n; ++j) {
                int n5 = j * bufferedImage.getWidth() / bufferedImage2.getWidth();
                double d4 = ImageUtil.scale(j, d) - (double)n5;
                int n6 = Math.min(bufferedImage.getWidth() - 1, n5 + 1);
                int n7 = Math.min(bufferedImage.getHeight() - 1, n4 + 1);
                int n8 = ImageUtil.getRGBInterpolation(bufferedImage.getRGB(n5, n4), bufferedImage.getRGB(n6, n4), d4);
                int n9 = ImageUtil.getRGBInterpolation(bufferedImage.getRGB(n5, n7), bufferedImage.getRGB(n6, n7), d4);
                int n10 = ImageUtil.getRGBInterpolation(n8, n9, d3);
                bufferedImage2.setRGB(j, i, n10);
            }
        }
        return bufferedImage2;
    }

    private static double scale(int n, double d) {
        return (double)n / d;
    }

    private static int getRGBInterpolation(int n, int n2, double d) {
        int n3 = (n & 0xFF000000) >>> 24;
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF000000) >>> 24;
        int n8 = (n2 & 0xFF0000) >> 16;
        int n9 = (n2 & 0xFF00) >> 8;
        int n10 = n2 & 0xFF;
        int n11 = (int)((double)n3 * (1.0 - d) + (double)n7 * d) << 24 | (int)((double)n4 * (1.0 - d) + (double)n8 * d) << 16 | (int)((double)n5 * (1.0 - d) + (double)n9 * d) << 8 | (int)((double)n6 * (1.0 - d) + (double)n10 * d);
        return n11;
    }

    public static boolean hasAlpha(Image image) {
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
            pixelGrabber.grabPixels();
            return pixelGrabber.getColorModel().hasAlpha();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public static final void pressImage(String string, String string2, int n, int n2, float f) {
        try {
            String string3 = ImageUtil.getSuffix(string, IMAGE_JPEG);
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            int n3 = ((Image)bufferedImage).getWidth(null);
            int n4 = ((Image)bufferedImage).getHeight(null);
            BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, 0, 0, n3, n4, null);
            BufferedImage bufferedImage3 = ImageIO.read(new File(string2));
            int n5 = ((Image)bufferedImage3).getWidth(null);
            int n6 = ((Image)bufferedImage3).getHeight(null);
            graphics2D.setComposite(AlphaComposite.getInstance(10, f));
            int n7 = n3 - n5;
            int n8 = n4 - n6;
            if (n < 0) {
                n = n7 / 2;
            } else if (n > n7) {
                n = n7;
            }
            if (n2 < 0) {
                n2 = n8 / 2;
            } else if (n2 > n8) {
                n2 = n8;
            }
            graphics2D.drawImage(bufferedImage3, n, n2, n5, n6, null);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage2, string3, file);
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
    }

    public static void pressText(String string, String string2, String string3, int n, int n2, Color color, int n3, int n4, float f) {
        try {
            String string4 = ImageUtil.getSuffix(string, IMAGE_JPEG);
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            int n5 = ((Image)bufferedImage).getWidth(null);
            int n6 = ((Image)bufferedImage).getHeight(null);
            BufferedImage bufferedImage2 = new BufferedImage(n5 - 500, n6 - 400, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, -250, -200, n5, n6, null);
            graphics2D.setFont(new Font(string3, n, n2));
            graphics2D.setColor(color);
            graphics2D.setComposite(AlphaComposite.getInstance(10, f));
            int n7 = n2 * ImageUtil.getLength(string2);
            int n8 = n2;
            int n9 = n5 - n7;
            int n10 = n6 - n8;
            if (n3 < 0) {
                n3 = n9 / 2;
            } else if (n3 > n9) {
                n3 = n9;
            }
            if (n4 < 0) {
                n4 = n10 / 2;
            } else if (n4 > n10) {
                n4 = n10;
            }
            graphics2D.drawString(string2, n3, n4 + n8);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage2, string4, file);
        }
        catch (Exception exception) {
            logger.error("", (Throwable)exception);
        }
    }

    public static int getLength(String string) {
        int n;
        int n2 = n = string.length();
        for (int i = 0; i < n; ++i) {
            if (String.valueOf(string.charAt(i)).getBytes().length <= 1) continue;
            ++n2;
        }
        return n2 % 2 == 0 ? n2 / 2 : n2 / 2 + 1;
    }

    public static void resize(String string, int n, int n2, boolean bl) {
        try {
            Object object;
            double d = 0.0;
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            Object object2 = bufferedImage.getScaledInstance(n2, n, 4);
            if (bufferedImage.getHeight() > n || bufferedImage.getWidth() > n2) {
                d = bufferedImage.getHeight() > bufferedImage.getWidth() ? new Integer(n).doubleValue() / (double)bufferedImage.getHeight() : new Integer(n2).doubleValue() / (double)bufferedImage.getWidth();
                object = new AffineTransformOp(AffineTransform.getScaleInstance(d, d), null);
                object2 = ((AffineTransformOp)object).filter(bufferedImage, null);
            }
            if (bl) {
                object = new BufferedImage(n2, n, 1);
                Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, n2, n);
                if (n2 == ((Image)object2).getWidth(null)) {
                    graphics2D.drawImage((Image)object2, 0, (n - ((Image)object2).getHeight(null)) / 2, ((Image)object2).getWidth(null), ((Image)object2).getHeight(null), Color.white, null);
                } else {
                    graphics2D.drawImage((Image)object2, (n2 - ((Image)object2).getWidth(null)) / 2, 0, ((Image)object2).getWidth(null), ((Image)object2).getHeight(null), Color.white, null);
                }
                graphics2D.dispose();
                object2 = object;
            }
            ImageIO.write((RenderedImage)((BufferedImage)object2), IMAGE_JPEG, file);
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
    }

    public static void scaleByWidth(String string, int n) {
        try {
            double d = 0.0;
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            int n2 = bufferedImage.getWidth(null);
            int n3 = bufferedImage.getHeight(null);
            Image image = bufferedImage.getScaledInstance(n2, n3, 4);
            if (bufferedImage.getWidth() > n) {
                d = new Integer(n).doubleValue() / (double)n2;
                AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d, d), null);
                image = affineTransformOp.filter(bufferedImage, null);
            }
            ImageIO.write((RenderedImage)((BufferedImage)image), IMAGE_JPEG, file);
        }
        catch (IOException iOException) {
            logger.error("scaleByWidth error!", (Throwable)iOException);
        }
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, int n, Color color) throws IOException {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if ((n %= 360) < 0) {
            n = 360 + n;
        }
        double d = Math.toRadians(n);
        if (n == 180 || n == 0 || n == 360) {
            n4 = n2;
            n5 = n3;
        } else if (n == 90 || n == 270) {
            n4 = n3;
            n5 = n2;
        } else {
            int n8 = n2 + n3;
            n4 = (int)((double)n8 * Math.abs(Math.cos(d)));
            n5 = (int)((double)n8 * Math.abs(Math.sin(d)));
        }
        n6 = n4 / 2 - n2 / 2;
        n7 = n5 / 2 - n3 / 2;
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        if (color == null) {
            bufferedImage2 = graphics2D.getDeviceConfiguration().createCompatibleImage(n4, n5, 1);
        } else {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n4, n5);
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, n4 / 2, n5 / 2);
        affineTransform.translate(n6, n7);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        bufferedImage = bufferedImage2;
        return bufferedImage;
    }

    public static InputStream rotateImg(BufferedImage bufferedImage, int n, Color color) throws IOException {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if ((n %= 360) < 0) {
            n = 360 + n;
        }
        double d = Math.toRadians(n);
        if (n == 180 || n == 0 || n == 360) {
            n4 = n2;
            n5 = n3;
        } else if (n == 90 || n == 270) {
            n4 = n3;
            n5 = n2;
        } else {
            int n8 = n2 + n3;
            n4 = (int)((double)n8 * Math.abs(Math.cos(d)));
            n5 = (int)((double)n8 * Math.abs(Math.sin(d)));
        }
        n6 = n4 / 2 - n2 / 2;
        n7 = n5 / 2 - n3 / 2;
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, bufferedImage.getType());
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        if (color == null) {
            bufferedImage2 = graphics2D.getDeviceConfiguration().createCompatibleImage(n4, n5, 3);
        } else {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n4, n5);
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, n4 / 2, n5 / 2);
        affineTransform.translate(n6, n7);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        bufferedImage = bufferedImage2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        ImageIO.write((RenderedImage)bufferedImage, IMAGE_PNG, imageOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return byteArrayInputStream;
    }

    public static Graphics2D drawAL(int n, int n2, int n3, int n4, Graphics2D graphics2D) {
        logger.info("drawAL sx:" + n + "  sy:" + n2 + "  ex:" + n3 + "  ey:" + n4);
        double d = 10.0;
        double d2 = 4.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d3 = Math.atan(d2 / d);
        double d4 = Math.sqrt(d2 * d2 + d * d);
        double[] dArray = ImageUtil.rotateVec(n3 - n, n4 - n2, d3, true, d4);
        double[] dArray2 = ImageUtil.rotateVec(n3 - n, n4 - n2, -d3, true, d4);
        double d5 = (double)n3 - dArray[0];
        double d6 = (double)n4 - dArray[1];
        double d7 = (double)n3 - dArray2[0];
        double d8 = (double)n4 - dArray2[1];
        Double d9 = new Double(d5);
        n5 = d9.intValue();
        Double d10 = new Double(d6);
        n6 = d10.intValue();
        Double d11 = new Double(d7);
        n7 = d11.intValue();
        Double d12 = new Double(d8);
        n8 = d12.intValue();
        graphics2D.drawLine(n, n2, n3, n4);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n3, n4);
        generalPath.lineTo(n5, n6);
        generalPath.lineTo(n7, n8);
        generalPath.closePath();
        graphics2D.fill(generalPath);
        return graphics2D;
    }

    private static double[] rotateVec(int n, int n2, double d, boolean bl, double d2) {
        double[] dArray = new double[2];
        double d3 = (double)n * Math.cos(d) - (double)n2 * Math.sin(d);
        double d4 = (double)n * Math.sin(d) + (double)n2 * Math.cos(d);
        if (bl) {
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            d3 = d3 / d5 * d2;
            d4 = d4 / d5 * d2;
            dArray[0] = d3;
            dArray[1] = d4;
        }
        return dArray;
    }

    public static void addText(String string, String string2) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        int n = ((Image)bufferedImage).getWidth(null);
        int n2 = ((Image)bufferedImage).getHeight(null);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2 + 20, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, n2, n, 20);
        graphics2D.setColor(Color.red);
        graphics2D.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        graphics2D.drawString(string2, 0, n2 + 16);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage2, IMAGE_JPEG, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toBase64(String string) {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            byArray = new byte[((InputStream)fileInputStream).available()];
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
            String string2 = EncryptUtil.base64Encode(byArray);
            return string2;
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
            String string3 = null;
            return string3;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    logger.error("", (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fromBase64(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf("base64,");
        if (n != -1) {
            string = string.substring(n + 7);
        }
        OutputStream outputStream = null;
        try {
            boolean bl;
            byte[] byArray = EncryptUtil.base64Decode(string, "UTF-8");
            for (bl = false; bl < byArray.length; bl += 1) {
                if (byArray[bl] >= 0) continue;
                boolean bl2 = bl;
                byArray[bl2] = (byte)(byArray[bl2] + 256);
            }
            outputStream = new FileOutputStream(string2);
            outputStream.flush();
            outputStream.write(byArray);
            bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("", (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutJPG(InputStream inputStream, OutputStream outputStream, int n, int n2, int n3, int n4) {
        ImageInputStream imageInputStream = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(IMAGE_JPEG);
            ImageReader imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            imageReader.setInput(imageInputStream, true);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            imageReadParam.setSourceRegion(rectangle);
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            ImageIO.write((RenderedImage)bufferedImage, IMAGE_JPEG, outputStream);
        }
        catch (IOException iOException) {
            logger.error("cutJPG error!", (Throwable)iOException);
        }
        finally {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                logger.error("cutJPG error!", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutPNG(InputStream inputStream, OutputStream outputStream, int n, int n2, int n3, int n4) {
        ImageInputStream imageInputStream = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(IMAGE_PNG);
            ImageReader imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            imageReader.setInput(imageInputStream, true);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            imageReadParam.setSourceRegion(rectangle);
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            ImageIO.write((RenderedImage)bufferedImage, IMAGE_PNG, outputStream);
        }
        catch (IOException iOException) {
            logger.error("cutPNG error!", (Throwable)iOException);
        }
        finally {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                logger.error("cutPNG error!", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutImage(InputStream inputStream, OutputStream outputStream, int n, int n2, int n3, int n4, String string) {
        ImageInputStream imageInputStream = null;
        try {
            logger.debug("imageType:" + string);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
            if (!iterator.hasNext()) {
                return;
            }
            ImageReader imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            imageReader.setInput(imageInputStream, true);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            imageReadParam.setSourceRegion(rectangle);
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
        catch (IOException iOException) {
            logger.error("cutImage error!", (Throwable)iOException);
        }
        finally {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                logger.error("cutImage error!", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageExtension(String string) {
        FileInputStream fileInputStream = null;
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        try {
            fileInputStream = new FileInputStream(new File(string));
            byte[] byArray = new byte[1];
            fileInputStream.read(byArray);
            String string3 = Integer.toHexString(byArray[0] & 0xFF);
            if (JPG_HEX.equals(string3)) {
                string2 = IMAGE_JPEG;
            }
            if (PNG_HEX.equals(string3)) {
                string2 = IMAGE_PNG;
            }
        }
        catch (Exception exception) {
            logger.error("getImageExtension error!", (Throwable)exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error("getImageExtension error!", (Throwable)iOException);
            }
        }
        return string2;
    }
}

