/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.alibaba.fastjson.JSON;
import com.jsmframe.http.HttpClientProcessor;
import com.jsmframe.utils.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class HttpClientUtil {
    private static Logger logger = LogUtil.log(HttpClientUtil.class);
    private static String DEFAULT_CHARSET = "utf8";
    private static HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException iOException, int n, HttpContext httpContext) {
            return false;
        }
    };

    public static String get(String string) {
        return HttpClientUtil.get(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(HttpHost httpHost, String string) {
        logger.info("get url:" + string);
        String string2 = null;
        CloseableHttpClient closeableHttpClient = httpHost == null ? HttpClientUtil.createClient() : HttpClientUtil.createClient(httpHost);
        try {
            HttpGet httpGet = new HttpGet(string);
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);){
                logger.info("get url status:" + closeableHttpResponse.getStatusLine());
                string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)DEFAULT_CHARSET);
            }
        }
        catch (Exception exception) {
            logger.error("http get error:" + string, (Throwable)exception);
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                logger.error("httpclient close error!", (Throwable)iOException);
            }
        }
        return string2;
    }

    public static String post(String string, List<NameValuePair> list) {
        return HttpClientUtil.post(null, string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(HttpHost httpHost, String string, List<NameValuePair> list) {
        logger.info("post url:" + string);
        logger.debug("nvps:" + JSON.toJSONString(list));
        String string2 = null;
        CloseableHttpClient closeableHttpClient = httpHost == null ? HttpClientUtil.createClient() : HttpClientUtil.createClient(httpHost);
        try {
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "utf-8"));
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                logger.info(closeableHttpResponse.getStatusLine().toString());
                string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)DEFAULT_CHARSET);
            }
        }
        catch (Exception exception) {
            logger.error("http post error:" + string, (Throwable)exception);
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                logger.error("httpclient close error!", (Throwable)iOException);
            }
        }
        return string2;
    }

    public static String post(String string, Object object) {
        if (object instanceof String) {
            return HttpClientUtil.post(null, string, (String)object);
        }
        return HttpClientUtil.post(null, string, JSON.toJSONString((Object)object));
    }

    public static String post(String string, String string2) {
        return HttpClientUtil.post(null, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(HttpHost httpHost, String string, String string2) {
        logger.info("post url:" + string);
        logger.debug("strEntity:" + JSON.toJSONString((Object)string2));
        String string3 = null;
        CloseableHttpClient closeableHttpClient = httpHost == null ? HttpClientUtil.createClient() : HttpClientUtil.createClient(httpHost);
        try {
            HttpPost httpPost = new HttpPost(string);
            StringEntity stringEntity = new StringEntity(string2, DEFAULT_CHARSET);
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                logger.info(closeableHttpResponse.getStatusLine().toString());
                string3 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            }
        }
        catch (Exception exception) {
            logger.error("http post error:" + string, (Throwable)exception);
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                logger.error("httpclient close error!", (Throwable)iOException);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String put(String string, String string2) {
        logger.info("put url:" + string);
        logger.debug("strEntity:" + JSON.toJSONString((Object)string2));
        String string3 = null;
        CloseableHttpClient closeableHttpClient = HttpClientUtil.createClient();
        try {
            HttpPut httpPut = new HttpPut(string);
            StringEntity stringEntity = new StringEntity(string2, DEFAULT_CHARSET);
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPut.setEntity((HttpEntity)stringEntity);
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPut);){
                logger.info(closeableHttpResponse.getStatusLine().toString());
                string3 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            }
        }
        catch (Exception exception) {
            logger.error("http put error:" + string, (Throwable)exception);
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                logger.error("httpclient close error!", (Throwable)iOException);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String delete(String string) {
        logger.info("delete url:" + string);
        String string2 = null;
        CloseableHttpClient closeableHttpClient = HttpClientUtil.createClient();
        try {
            HttpDelete httpDelete = new HttpDelete(string);
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpDelete);){
                logger.info(closeableHttpResponse.getStatusLine().toString());
                string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)DEFAULT_CHARSET);
            }
        }
        catch (Exception exception) {
            logger.error("http delete error:" + string, (Throwable)exception);
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                logger.error("httpclient close error!", (Throwable)iOException);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImage(String string, String string2, List<Header> list) {
        logger.info("getImage url:" + string);
        CloseableHttpClient closeableHttpClient = HttpClientUtil.createClient();
        CloseableHttpResponse closeableHttpResponse = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            if (list != null) {
                httpGet.setHeaders(list.toArray(new Header[list.size()]));
            }
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            logger.info("get image url:" + closeableHttpResponse.getStatusLine());
            outputStream = new FileOutputStream(string2);
            inputStream = closeableHttpResponse.getEntity().getContent();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                ((FileOutputStream)outputStream).write(byArray, 0, n);
            }
            String string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            logger.error("http get error:" + string, (Throwable)exception);
            String string4 = null;
            return string4;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient.close();
                }
            }
            catch (IOException iOException) {
                logger.error("httpclient getImage close error!", (Throwable)iOException);
            }
        }
    }

    public static String getFile(String string, String string2) {
        return HttpClientUtil.getFile(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFile(String string, String string2, List<Header> list) {
        logger.info("getFile url:" + string);
        CloseableHttpClient closeableHttpClient = HttpClientUtil.createClient();
        CloseableHttpResponse closeableHttpResponse = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            if (list != null) {
                httpGet.setHeaders(list.toArray(new Header[list.size()]));
            }
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            logger.info("get file url:" + closeableHttpResponse.getStatusLine());
            outputStream = new FileOutputStream(string2);
            inputStream = closeableHttpResponse.getEntity().getContent();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                ((FileOutputStream)outputStream).write(byArray, 0, n);
            }
            String string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            logger.error("http get error:" + string, (Throwable)exception);
            String string4 = null;
            return string4;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient.close();
                }
            }
            catch (IOException iOException) {
                logger.error("httpclient getFile close error!", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String string, List<Header> list, HttpClientProcessor httpClientProcessor) {
        logger.info("get url:" + string);
        CloseableHttpClient closeableHttpClient = HttpClientUtil.createClient();
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            if (list != null) {
                httpGet.setHeaders(list.toArray(new Header[list.size()]));
            }
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            logger.info("get url:" + closeableHttpResponse.getStatusLine());
            httpClientProcessor.process((HttpResponse)closeableHttpResponse);
        }
        catch (Exception exception) {
            logger.error("http get error:" + string, (Throwable)exception);
        }
        finally {
            try {
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient.close();
                }
            }
            catch (IOException iOException) {
                logger.error("httpclient get close error!", (Throwable)iOException);
            }
        }
    }

    public static String postFile(String string, String string2) {
        return HttpClientUtil.postFile(string, "file", string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String string, String string2, String string3) {
        logger.info("postFile url:{},filePath:{}", (Object)string, (Object)string3);
        String string4 = null;
        CloseableHttpClient closeableHttpClient = HttpClientUtil.createClient();
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(1000).setSocketTimeout(600000).build();
            HttpPost httpPost = new HttpPost(string);
            httpPost.setConfig(requestConfig);
            FileBody fileBody = new FileBody(new File(string3));
            long l = fileBody.getContentLength();
            logger.info("postFile size:" + l / 1024L + "KB");
            HttpEntity httpEntity = MultipartEntityBuilder.create().addBinaryBody(string2, new File(string3)).build();
            httpPost.setEntity(httpEntity);
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                logger.info(closeableHttpResponse.getStatusLine().toString());
                string4 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                logger.info("postFile res:" + string4);
            }
        }
        catch (Exception exception) {
            logger.error("http postFile error:" + string, (Throwable)exception);
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                logger.error("httpclient close error!", (Throwable)iOException);
            }
        }
        return string4;
    }

    private static CloseableHttpClient createClient() {
        return HttpClientUtil.createClient(null);
    }

    private static CloseableHttpClient createClient(HttpHost httpHost) {
        Object object;
        SSLConnectionSocketFactory sSLConnectionSocketFactory = null;
        try {
            object = new SSLContextBuilder().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    return true;
                }
            }).build();
            sSLConnectionSocketFactory = new SSLConnectionSocketFactory((SSLContext)object, (HostnameVerifier)new NoopHostnameVerifier());
        }
        catch (Exception exception) {
            logger.error("create ssl socket factory error!", (Throwable)exception);
        }
        object = HttpClientBuilder.create();
        if (httpHost != null) {
            object.setProxy(httpHost);
        }
        if (sSLConnectionSocketFactory != null) {
            object.setSSLSocketFactory(sSLConnectionSocketFactory);
        }
        object.setRetryHandler(myRetryHandler);
        return object.build();
    }
}

