/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class HttpBrowser {
    private Logger logger = LogUtil.log(HttpBrowser.class);
    private List<Header> headers;
    private HttpClientContext context = null;
    private CookieStore cookieStore = null;
    private HttpHost proxyHost = null;

    private HttpBrowser(List<Header> list, HttpHost httpHost) {
        this.headers = list != null ? list : HttpBrowser.getDeaultHeader();
        this.context = HttpClientContext.create();
        this.cookieStore = new BasicCookieStore();
        this.proxyHost = httpHost;
    }

    private CloseableHttpClient createClient() {
        SSLContext sSLContext;
        SSLConnectionSocketFactory sSLConnectionSocketFactory = null;
        try {
            sSLContext = new SSLContextBuilder().loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    return true;
                }
            }).build();
            sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, (HostnameVerifier)new NoopHostnameVerifier());
        }
        catch (Exception exception) {
            this.logger.error("create ssl socket factory error!", (Throwable)exception);
        }
        sSLContext = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setDefaultCookieStore(this.cookieStore).setDefaultHeaders(this.headers);
        if (this.proxyHost != null) {
            sSLContext.setProxy(this.proxyHost);
        }
        if (sSLConnectionSocketFactory != null) {
            sSLContext.setSSLSocketFactory((LayeredConnectionSocketFactory)sSLConnectionSocketFactory);
        }
        return sSLContext.build();
    }

    public HttpGet proxyHttpGet(HttpGet httpGet) {
        return httpGet;
    }

    public HttpPost proxyHttpPost(HttpPost httpPost) {
        return httpPost;
    }

    public static HttpBrowser open() {
        return HttpBrowser.open(HttpBrowser.getDeaultHeader());
    }

    public static HttpBrowser open(List<Header> list) {
        HttpBrowser httpBrowser = new HttpBrowser(list, null);
        return httpBrowser;
    }

    public static HttpBrowser open(List<Header> list, HttpHost httpHost) {
        HttpBrowser httpBrowser = new HttpBrowser(list, httpHost);
        return httpBrowser;
    }

    public static HttpBrowser open(HttpHost httpHost) {
        HttpBrowser httpBrowser = new HttpBrowser(null, httpHost);
        return httpBrowser;
    }

    public String get(String string) {
        return this.get(string, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string, String string2) {
        this.logger.info("get url:" + string);
        String string3 = null;
        CloseableHttpClient closeableHttpClient = null;
        try {
            closeableHttpClient = this.createClient();
            HttpGet httpGet = new HttpGet(string);
            httpGet = this.proxyHttpGet(httpGet);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);
            try {
                this.logger.info("get url status:" + closeableHttpResponse.getStatusLine());
                string3 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)string2);
            }
            catch (Exception exception) {
                this.logger.error("http get read error:" + string, (Throwable)exception);
            }
            finally {
                closeableHttpResponse.close();
                closeableHttpClient.close();
            }
        }
        catch (Exception exception) {
            this.logger.error("http get error:" + string, (Throwable)exception);
        }
        return string3;
    }

    public String post(String string, List<NameValuePair> list) {
        return this.post(string, list, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String string, List<NameValuePair> list, String string2) {
        this.logger.info("post url:" + string);
        String string3 = null;
        CloseableHttpClient closeableHttpClient = null;
        try {
            closeableHttpClient = this.createClient();
            HttpPost httpPost = new HttpPost(string);
            httpPost = this.proxyHttpPost(httpPost);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, string2));
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);
            try {
                this.logger.info(closeableHttpResponse.getStatusLine().toString());
                int n = closeableHttpResponse.getStatusLine().getStatusCode();
                if (n >= 300 && n < 400) {
                    Header header = closeableHttpResponse.getFirstHeader("location");
                    if (header != null) {
                        string3 = header.toString();
                    }
                } else {
                    string3 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)string2);
                }
            }
            catch (Exception exception) {
                this.logger.error("http get read error:" + string, (Throwable)exception);
            }
            finally {
                closeableHttpResponse.close();
                closeableHttpClient.close();
            }
        }
        catch (Exception exception) {
            this.logger.error("http get error:" + string, (Throwable)exception);
        }
        return string3;
    }

    public String post(String string, String string2) {
        return this.post(string, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String string, String string2, String string3) {
        this.logger.info("post url:" + string);
        String string4 = null;
        CloseableHttpClient closeableHttpClient = null;
        try {
            closeableHttpClient = this.createClient();
            HttpPost httpPost = new HttpPost(string);
            httpPost = this.proxyHttpPost(httpPost);
            StringEntity stringEntity = new StringEntity(string2, string3);
            stringEntity.setContentEncoding(string3);
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);
            try {
                this.logger.info(closeableHttpResponse.getStatusLine().toString());
                string4 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)string3);
            }
            catch (Exception exception) {
                this.logger.error("http get read error:" + string, (Throwable)exception);
            }
            finally {
                closeableHttpResponse.close();
                closeableHttpClient.close();
            }
        }
        catch (Exception exception) {
            this.logger.error("http get error:" + string, (Throwable)exception);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImage(String string, String string2) {
        this.logger.info("getImage url:" + string);
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse closeableHttpResponse = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            closeableHttpClient = this.createClient();
            HttpGet httpGet = new HttpGet(string);
            httpGet = this.proxyHttpGet(httpGet);
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);
            this.logger.info("get image url:" + closeableHttpResponse.getStatusLine());
            outputStream = new FileOutputStream(string2);
            inputStream = closeableHttpResponse.getEntity().getContent();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                ((FileOutputStream)outputStream).write(byArray, 0, n);
            }
            String string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            this.logger.error("http get error:" + string, (Throwable)exception);
            String string4 = null;
            return string4;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                if (closeableHttpResponse != null) {
                    closeableHttpResponse.close();
                }
                if (closeableHttpClient != null) {
                    closeableHttpClient.close();
                }
            }
            catch (IOException iOException) {
                this.logger.error("httpClient getImage close error!", (Throwable)iOException);
            }
        }
    }

    public String postImage(String string, String string2) {
        return this.postImage(string, string2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postImage(String string, String string2, String string3) {
        this.logger.info("postImage url:" + string);
        String string4 = null;
        try {
            CloseableHttpClient closeableHttpClient = this.createClient();
            HttpPost httpPost = new HttpPost(string);
            httpPost = this.proxyHttpPost(httpPost);
            FileBody fileBody = new FileBody(new File(string2));
            long l = fileBody.getContentLength();
            this.logger.info("postImage image size:" + l / 1024L + "KB");
            HttpEntity httpEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)fileBody).build();
            httpPost.setEntity(httpEntity);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);
            try {
                this.logger.info(closeableHttpResponse.getStatusLine().toString());
                string4 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)string3);
                this.logger.info("postImage res:" + string4);
            }
            catch (Exception exception) {
                this.logger.error("http get read error:" + string, (Throwable)exception);
            }
            finally {
                closeableHttpResponse.close();
                closeableHttpClient.close();
            }
        }
        catch (Exception exception) {
            this.logger.error("http get error:" + string, (Throwable)exception);
        }
        return string4;
    }

    public void addCookie(String string, String string2, String string3, String string4) {
        BasicClientCookie basicClientCookie = new BasicClientCookie(string, string2);
        basicClientCookie.setDomain(string3);
        basicClientCookie.setPath(string4);
        this.cookieStore.addCookie((Cookie)basicClientCookie);
    }

    private static List<Header> getDeaultHeader() {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        arrayList.add((Header)new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"));
        arrayList.add((Header)new BasicHeader("Accept-Encoding", "gzip, deflate, sdch"));
        arrayList.add((Header)new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8"));
        arrayList.add((Header)new BasicHeader("Cache-Control", "max-age=0"));
        arrayList.add((Header)new BasicHeader("Connection", "keep-alive"));
        arrayList.add((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.94 Safari/537.36"));
        return arrayList;
    }
}

