/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;

public class HtmlUtil {
    private static Logger logger = LogUtil.log(HtmlUtil.class);
    private static String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
    private static String regEx_css = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
    private static String regEx_html = "<[^>]+>";

    public static String filter(String string) {
        if (string == null) {
            return "";
        }
        string = HtmlUtil.jsFilter(string);
        string = HtmlUtil.cssFilter(string);
        string = HtmlUtil.htmlFilter(string);
        return string;
    }

    public static String jsFilter(String string) {
        if (string == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(regEx_script, 2);
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("");
        return string;
    }

    public static String htmlFilter(String string) {
        if (string == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(regEx_html, 2);
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("");
        return string;
    }

    public static String cssFilter(String string) {
        if (string == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(regEx_css, 2);
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("");
        return string;
    }

    public static Document getDocument(String string) {
        Document document = null;
        try {
            document = Jsoup.connect((String)string).get();
        }
        catch (IOException iOException) {
            logger.error("getDocument error url:" + string, (Throwable)iOException);
        }
        return document;
    }

    public static Document parse(String string) {
        Document document = null;
        try {
            document = Jsoup.parse((String)string);
        }
        catch (Exception exception) {
            logger.error("parse error html:" + string, (Throwable)exception);
        }
        return document;
    }
}

