/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;

public class FileEncryptUtil {
    private static Logger logger = LogUtil.log(FileEncryptUtil.class);

    public static Key getKey(String string) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
            keyGenerator.init(new SecureRandom(string.getBytes()));
            SecretKey secretKey = keyGenerator.generateKey();
            keyGenerator = null;
            return secretKey;
        }
        catch (Exception exception) {
            logger.error("getKey error!", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(String string, String string2, String string3) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        CipherInputStream cipherInputStream = null;
        try {
            int n;
            Key key = FileEncryptUtil.getKey(string3);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, key);
            inputStream = new FileInputStream(string);
            outputStream = new FileOutputStream(string2);
            cipherInputStream = new CipherInputStream(inputStream, cipher);
            byte[] byArray = new byte[1024];
            while ((n = cipherInputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            logger.error("encrypt error!", (Throwable)exception);
        }
        finally {
            try {
                if (cipherInputStream != null) {
                    cipherInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error("encrypt error!", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(String string, String string2, String string3) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        CipherOutputStream cipherOutputStream = null;
        try {
            int n;
            Cipher cipher = Cipher.getInstance("DES");
            Key key = FileEncryptUtil.getKey(string3);
            cipher.init(2, key);
            inputStream = new FileInputStream(string);
            outputStream = new FileOutputStream(string2);
            cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                cipherOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            logger.error("decrypt error!", (Throwable)exception);
        }
        finally {
            try {
                if (cipherOutputStream != null) {
                    cipherOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                logger.error("decrypt error!", (Throwable)exception);
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

