/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.PropUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;

public class EncryptUtil {
    private static Logger logger = LogUtil.log(PropUtil.class);

    public static String md5(String string) {
        return EncryptUtil.encode(string, "MD5").toUpperCase();
    }

    public static String sha(String string) {
        return EncryptUtil.encode(string, "SHA");
    }

    public static String sha1(String string) {
        return EncryptUtil.encode(string, "SHA-1");
    }

    public static String base64Encode(String string) {
        String string2 = "UTF-8";
        return EncryptUtil.base64Encode(string.getBytes(), string2);
    }

    public static String base64Encode(byte[] byArray) {
        String string = "UTF-8";
        return EncryptUtil.base64Encode(byArray, string);
    }

    public static String base64Encode(byte[] byArray, String string) {
        try {
            Base64 base64 = new Base64();
            return new String(base64.encode(byArray), string);
        }
        catch (Exception exception) {
            logger.error("base64Encode error!", (Throwable)exception);
            return null;
        }
    }

    public static String base64Decode(String string) {
        String string2 = "UTF-8";
        return new String(EncryptUtil.base64Decode(string, string2));
    }

    public static byte[] base64Decode(String string, String string2) {
        try {
            Base64 base64 = new Base64();
            return base64.decode(string);
        }
        catch (Exception exception) {
            logger.error("base64Decode error!", (Throwable)exception);
            return null;
        }
    }

    private static String encode(String string, String string2) {
        MessageDigest messageDigest = null;
        StringBuilder stringBuilder = new StringBuilder(32);
        try {
            messageDigest = MessageDigest.getInstance(string2);
            byte[] byArray = messageDigest.digest(string.getBytes());
            for (int i = 0; i < byArray.length; ++i) {
                String string3 = Integer.toHexString(byArray[i] & 0xFF);
                if (string3.length() == 1) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error("encode error!", (Throwable)noSuchAlgorithmException);
            return stringBuilder.toString();
        }
    }

    public static String byteToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("lappmd5\u52a0\u5bc6:" + EncryptUtil.md5("hc123").toLowerCase());
    }

    public static String soeEncode(String string) {
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] - 10 ^ 0xA);
        }
        Base64 base64 = new Base64();
        ArrayUtils.reverse((byte[])byArray);
        return new String(base64.encode(byArray));
    }

    public static String soeDecode(String string) {
        Base64 base64 = new Base64();
        byte[] byArray = base64.decode(string.getBytes());
        ArrayUtils.reverse((byte[])byArray);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)((byArray[i] ^ 0xA) + 10);
        }
        return new String(byArray);
    }

    public static String lappMd5(String string) {
        return EncryptUtil.md5(EncryptUtil.base64Encode(string + "@lapp") + string + EncryptUtil.base64Encode(string));
    }

    public static String lappSha(String string) {
        return EncryptUtil.sha(EncryptUtil.base64Encode(string + "@lapp") + string + EncryptUtil.base64Encode(string));
    }

    public static String urlDecode(String string) {
        return EncryptUtil.urlDecode(string, "UTF-8");
    }

    public static String urlEncode(String string) {
        return EncryptUtil.urlEncode(string, "UTF-8");
    }

    public static String urlDecode(String string, String string2) {
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("urlDecode error!", (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    public static String urlEncode(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("urlEncode error!", (Throwable)unsupportedEncodingException);
            return null;
        }
    }
}

