/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.exception.BaseException;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class DateUtil {
    private static Logger logger = LogUtil.log(DateUtil.class);
    public static long TIME_DIFF = 0L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final String SLASH_DATE_PATTERN = "yyyy/MM/dd";
    public static final String SLASH_TRIM_SECOND_PATTERN = "yyyy/MM/dd HH:mm";
    public static final String SLASH_DATETIME_PATTERN = "yyyy/MM/dd HH:mm:ss";
    public static final String COMPACT_DATE_PATTERN = "yyyyMMdd";
    public static final String COMPACT_TRIM_SECOND_PATTERN = "yyyyMMdd HH:mm";
    public static final String COMPACT_DATETIME_PATTERN = "yyyyMMdd HH:mm:ss";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TRIM_SECOND_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String el = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
    private static ThreadLocal<SimpleDateFormat> sdftl = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat();
        }
    };
    private static SimpleDateFormat adf = sdftl.get();

    public static Date currentDate() {
        Date date = new Date();
        if (TIME_DIFF == 0L) {
            return date;
        }
        return new Date(date.getTime() + TIME_DIFF);
    }

    public static Long currentTime() {
        return DateUtil.currentDate().getTime();
    }

    public static String format(Date date, String string) {
        if (date == null) {
            return null;
        }
        adf.applyPattern(string);
        return adf.format(date);
    }

    public static Date parse(String string, String string2) {
        adf.applyPattern(string2);
        try {
            return adf.parse(string);
        }
        catch (ParseException parseException) {
            logger.error("parse error!", (Throwable)parseException);
            return null;
        }
    }

    public static Date parse(String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        return DateUtil.parse(string, DateUtil.getPattern(string));
    }

    public static boolean isDate(String string) {
        return Pattern.compile(el).matcher(string).matches();
    }

    public static String getPattern(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length == 1) {
            if (stringArray[0].split("-").length == 3) {
                return DATE_PATTERN;
            }
            return COMPACT_DATE_PATTERN;
        }
        if (stringArray.length == 2) {
            if (stringArray[0].split("-").length == 3) {
                if (stringArray[1].split(":").length == 2) {
                    return TRIM_SECOND_PATTERN;
                }
                return DATETIME_PATTERN;
            }
            if (stringArray[1].split(":").length == 2) {
                return COMPACT_TRIM_SECOND_PATTERN;
            }
            return COMPACT_DATETIME_PATTERN;
        }
        throw new BaseException("\u975e\u6cd5\u65e5\u671f\u683c\u5f0f\uff01");
    }

    public static boolean oneDayAgo(Date date) {
        return DateUtil.currentTime() - date.getTime() > 86400000L;
    }

    public static boolean oneHourAgo(Date date) {
        return DateUtil.currentTime() - date.getTime() > 3600000L;
    }

    public static Calendar parseCalendar(String string, String string2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parse(string, string2));
        return calendar;
    }

    public static Date parse(Long l) {
        if (l == null) {
            return null;
        }
        return new Date(l);
    }

    public static String format(Calendar calendar, String string) {
        if (calendar == null) {
            return null;
        }
        return new SimpleDateFormat(string).format(calendar.getTime());
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(DATE_PATTERN).format(date);
    }

    public static int dayInWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int dayInWeekForUse(Date date) {
        int n = DateUtil.dayInWeek(date) - 1;
        return n == 0 ? 7 : n;
    }

    public static int dayInMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Date addDay(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, n);
        return calendar.getTime();
    }

    public static Date addSecond(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, n);
        return calendar.getTime();
    }

    public static Date addMilliSecond(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(14, n);
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date, Date date2) {
        return DateUtil.format(date).equals(DateUtil.format(date2));
    }

    public static long reduce(Date date, Date date2, long l) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        long l2 = calendar.getTimeInMillis() - calendar2.getTimeInMillis();
        return l2 / l;
    }

    public static Date dayOfEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date dayOfBegin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, n);
        return calendar.getTime();
    }

    public static Date setDay(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, n);
        return calendar.getTime();
    }

    public static Date setMonth(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, n);
        return calendar.getTime();
    }

    public static Date setYear(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, n);
        return calendar.getTime();
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }
}

