/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.LogUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;

public class ClassUtil {
    private static Logger logger = LogUtil.log(ClassUtil.class);

    public static boolean isComplexClass(Class<?> clazz) {
        try {
            if (clazz.isPrimitive() || clazz.equals(String.class)) {
                return false;
            }
            Field field = clazz.getField("TYPE");
            if (field != null && (clazz = (Class)field.get(null)) != null && clazz.isPrimitive()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isWrapClass(Class<?> clazz) {
        try {
            return ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Set<Class<?>> loadClass(String string) {
        return ClassUtil.loadClass(string, true);
    }

    public static Set<Class<?>> loadClass(String string, boolean bl) {
        HashSet hashSet = new HashSet();
        String string2 = string.replace('.', '/');
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources(string2);
            while (enumeration.hasMoreElements()) {
                Object object;
                URL uRL = enumeration.nextElement();
                if ("file".equals(uRL.getProtocol())) {
                    object = URLDecoder.decode(uRL.getFile(), "utf-8");
                    logger.info("find class in dir: {}", object);
                    ClassUtil.findClassesInFolder((String)object, string, bl, hashSet);
                    continue;
                }
                if (!"jar".equals(uRL.getProtocol())) continue;
                object = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = ((JarURLConnection)object).getJarFile();
                logger.info("find class in dir: {}", (Object)jarFile.getName());
                ClassUtil.findClassesInJar(jarFile, string2, bl, hashSet);
            }
        }
        catch (IOException iOException) {
            logger.error("scan package: {} error!", (Object)string, (Object)iOException);
        }
        return hashSet;
    }

    private static void findClassesInJar(JarFile jarFile, String string, boolean bl, Set<Class<?>> set) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if (string2.charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            if (!string2.startsWith(string) || !bl && string2.substring(string.length() + 1).contains("/") || !string2.endsWith(".class") || jarEntry.isDirectory()) continue;
            String string3 = string2.substring(0, string2.length() - 6).replace('/', '.');
            try {
                set.add(Thread.currentThread().getContextClassLoader().loadClass(string3));
            }
            catch (Exception exception) {
                logger.error("class not found {}", (Object)string3, (Object)exception);
            }
        }
    }

    private static void findClassesInFolder(String string, String string2, final boolean bl, Set<Class<?>> set) {
        File[] fileArray;
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return bl && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file2.isDirectory()) {
                ClassUtil.findClassesInFolder(string + "/" + file2.getName(), string2 + '.' + file2.getName(), bl, set);
                continue;
            }
            String string3 = file2.getName().substring(0, file2.getName().length() - 6);
            String string4 = string2 + '.' + string3;
            try {
                set.add(Thread.currentThread().getContextClassLoader().loadClass(string4));
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("class not found {}", (Object)string4, (Object)classNotFoundException);
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "org.apache.commons.beanutils";
        for (Class<?> clazz : ClassUtil.loadClass(string, false)) {
            System.out.println(clazz.getName());
        }
    }
}

