/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.utils;

import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.Date;
import org.slf4j.Logger;

public class BeanUtil {
    private static Logger logger = LogUtil.log(BeanUtil.class);

    public static void copy(Object object, Object object2, String ... stringArray) {
        Field[] fieldArray;
        for (Field field : fieldArray = object.getClass().getFields()) {
            Field field2;
            String string = field.getName();
            if (BeanUtil.ignore(string, stringArray) || (field2 = BeanUtil.getField(object2, string)) == null) continue;
            BeanUtil.copyField(object, object2, field, field2);
        }
    }

    public static void setFieldValue(Object object, Field field, Object object2) {
        if (object2 == null) {
            return;
        }
        try {
            Class<?> clazz = field.getType();
            if (clazz.isAssignableFrom(object2.getClass())) {
                field.set(object, object2);
            } else {
                String string = object2.toString();
                logger.debug("field type:" + clazz);
                logger.debug("valueStr:" + string);
                if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
                    object2 = Float.valueOf(string).intValue();
                } else if (clazz.isAssignableFrom(Date.class)) {
                    object2 = DateUtil.parse(string);
                } else if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
                    object2 = Long.valueOf(string);
                } else if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
                    object2 = Float.valueOf(string);
                } else if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
                    object2 = Double.valueOf(string);
                } else if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE)) {
                    object2 = Short.valueOf(string);
                } else if (clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Byte.TYPE)) {
                    object2 = Byte.valueOf(string);
                } else if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
                    object2 = Boolean.valueOf(string);
                } else if (clazz.isAssignableFrom(String.class)) {
                    object2 = string;
                }
                field.set(object, object2);
            }
        }
        catch (Exception exception) {
            logger.error("setFieldValue error!", (Throwable)exception);
        }
    }

    private static void copyField(Object object, Object object2, Field field, Field field2) {
        try {
            Class<?> clazz = field2.getType();
            Class<?> clazz2 = field.getType();
            Object object3 = BeanUtil.getFieldValue(field, object);
            if (object3 == null) {
                return;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                field2.set(object2, object3);
            } else {
                String string = object3.toString();
                logger.debug("dest type:" + clazz);
                logger.debug("orgValueStr:" + string);
                if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
                    object3 = Float.valueOf(string).intValue();
                } else if (clazz.isAssignableFrom(Date.class)) {
                    object3 = DateUtil.parse(string);
                } else if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
                    object3 = Long.valueOf(string);
                } else if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
                    object3 = Float.valueOf(string);
                } else if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
                    object3 = Double.valueOf(string);
                } else if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE)) {
                    object3 = Short.valueOf(string);
                } else if (clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Byte.TYPE)) {
                    object3 = Byte.valueOf(string);
                } else if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
                    object3 = Boolean.valueOf(string);
                } else if (clazz.isAssignableFrom(String.class)) {
                    object3 = string;
                }
                field2.set(object2, object3);
            }
        }
        catch (Exception exception) {
            logger.error("copyField error:" + field.getName(), (Throwable)exception);
        }
    }

    private static Field getField(Object object, String string) {
        try {
            return object.getClass().getField(string);
        }
        catch (Exception exception) {
            logger.warn("getField {} error!", (Object)string);
            return null;
        }
    }

    private static boolean ignore(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Object getFieldValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            logger.error("getFieldValue error!", (Throwable)exception);
            return null;
        }
    }

    public static Object getFieldValue(String string, Object object) {
        try {
            if (!string.contains(".")) {
                Field field = BeanUtil.getDeclaredField(object, string);
                return field.get(object);
            }
            int n = string.indexOf(".");
            String string2 = string.substring(0, n);
            Field field = BeanUtil.getDeclaredField(object, string2);
            return BeanUtil.getFieldValue(string.substring(n + 1), field.get(object));
        }
        catch (Exception exception) {
            logger.error("getFieldValue error!", (Throwable)exception);
            return null;
        }
    }

    private static Field getDeclaredField(Object object, String string) {
        if (object == null) {
            logger.error("object is null ,can't get fieldName.{}", (Object)string);
            return null;
        }
        if (StringUtil.isEmpty(string)) {
            logger.error("fieldName is empty ,can't get fieldName.");
            return null;
        }
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }
}

