/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.session;

import com.alibaba.fastjson.JSON;
import com.jsmframe.context.ProjectContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.session.SessionUser;
import com.jsmframe.utils.StringUtil;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static Logger logger = LoggerFactory.getLogger(Session.class);
    private String token;
    private JedisService jedisService;
    private SessionUser sessionUser;
    private HttpSession session;
    private boolean invalid = false;
    private static String SESSION_USER = "SESSION_USER";
    private static String SESSION_USER_KEY_PREFIX = "SESSION_USER_KEY_PFRFIX_";

    public static Session create(String string) {
        Session session = new Session(string);
        session.set("sid", string);
        session.live();
        return session;
    }

    public Session(String string) {
        this.token = string;
        if (ProjectContext.isJedisSession()) {
            this.jedisService = SpringContext.getBean(JedisService.class);
        } else {
            this.session = WebContext.getRequest().getSession();
        }
    }

    public void set(String string, String string2) {
        if (ProjectContext.isJedisSession()) {
            this.jedisService.hset(this.token, string, string2);
        } else {
            this.session.setAttribute(string, (Object)string2);
        }
    }

    public Object get(String string) {
        if (ProjectContext.isJedisSession()) {
            return this.jedisService.hget(this.token, string);
        }
        return this.session.getAttribute(string);
    }

    public void del(String string) {
        if (ProjectContext.isJedisSession()) {
            this.jedisService.hdel(this.token, string);
        } else {
            this.session.removeAttribute(string);
        }
    }

    public void live() {
        logger.debug("live check!");
        if (ProjectContext.isJedisSession() && !this.invalid) {
            logger.debug("live");
            Integer n = ProjectContext.getAsInteger("session.timeout");
            this.jedisService.expire(this.token, n);
            if (this.sessionUser != null) {
                String string = SESSION_USER_KEY_PREFIX + this.sessionUser.getUid();
                this.jedisService.expire(string, n);
            }
        }
    }

    public String getToken() {
        return this.token;
    }

    public SessionUser getSessionUser() {
        if (this.sessionUser == null) {
            if (ProjectContext.isJedisSession()) {
                String string = (String)this.get(SESSION_USER);
                if (!StringUtil.isEmpty(string)) {
                    this.sessionUser = (SessionUser)JSON.parseObject((String)string, SessionUser.class);
                }
            } else {
                this.sessionUser = (SessionUser)this.session.getAttribute("sessionUser");
            }
        }
        return this.sessionUser;
    }

    public void setSessionUser(SessionUser sessionUser) {
        this.sessionUser = sessionUser;
        if (ProjectContext.isJedisSession()) {
            this.set(SESSION_USER, JSON.toJSONString((Object)sessionUser));
            String string = SESSION_USER_KEY_PREFIX + this.sessionUser.getUid();
            this.jedisService.set(string, this.token);
            logger.debug("setSessionUser ukey:{} , token:{}", (Object)string, (Object)this.token);
            this.live();
        } else {
            this.session.setAttribute(SESSION_USER, (Object)sessionUser);
        }
    }

    public boolean isExpire() {
        if (this.invalid) {
            return true;
        }
        if (ProjectContext.isJedisSession()) {
            return this.jedisService.exists(this.token) == false;
        }
        return false;
    }

    public void flush() {
        if (!this.invalid) {
            this.setSessionUser(this.sessionUser);
        }
    }

    public void invalid() {
        this.invalid = true;
        if (ProjectContext.isJedisSession()) {
            this.jedisService.del(this.token);
            String string = "";
            if (this.getSessionUser() != null) {
                string = SESSION_USER_KEY_PREFIX + this.getSessionUser().getUid();
                this.jedisService.del(string);
            }
            logger.debug("invalid ukey:{} , token:{}", (Object)string, (Object)this.token);
        }
    }

    public static boolean expire(Long l) {
        if (ProjectContext.isJedisSession()) {
            JedisService jedisService = SpringContext.getBean(JedisService.class);
            String string = SESSION_USER_KEY_PREFIX + l;
            String string2 = jedisService.get(string);
            jedisService.del(string);
            if (!StringUtil.isEmpty(string2)) {
                jedisService.del(string2);
            }
            logger.debug("expire ukey:{} , token:{}", (Object)string, (Object)string2);
        }
        return true;
    }

    public static boolean isLogon(Long l) {
        if (ProjectContext.isJedisSession()) {
            JedisService jedisService = SpringContext.getBean(JedisService.class);
            String string = SESSION_USER_KEY_PREFIX + l;
            boolean bl = jedisService.exists(string);
            logger.debug("uid:{}, isLogon:{}", (Object)l, (Object)bl);
            return bl;
        }
        return false;
    }
}

