/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.oauth;

import com.alibaba.fastjson.JSON;
import com.jsmframe.context.ProjectContext;
import com.jsmframe.oauth.model.App;
import com.jsmframe.oauth.model.AppResourceCode;
import com.jsmframe.oauth.model.OauthInfo;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.HttpClientUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

public class OauthContext {
    private static Logger logger = LogUtil.log(OauthContext.class);
    private static OauthInfo oauthInfo = null;
    private static Date atExpireTime = new Date();
    private static Date rtExpireTime = new Date();
    private static ThreadLocal<AppResourceCode> currentAppResourceCodeTl = new ThreadLocal();

    public static String getAccessToken() {
        if (oauthInfo == null || DateUtil.reduce(rtExpireTime, DateUtil.currentDate(), 1000L) < 10L) {
            oauthInfo = OauthContext.getAuthInfo();
            atExpireTime = DateUtil.addDay(DateUtil.currentDate(), OauthContext.oauthInfo.atExpireTime);
            rtExpireTime = DateUtil.addDay(DateUtil.currentDate(), OauthContext.oauthInfo.rtExpireTime);
        } else if (DateUtil.reduce(atExpireTime, DateUtil.currentDate(), 1000L) < 10L) {
            oauthInfo = OauthContext.getRefreshAuthInfo();
            atExpireTime = DateUtil.addDay(DateUtil.currentDate(), OauthContext.oauthInfo.atExpireTime);
            rtExpireTime = DateUtil.addDay(DateUtil.currentDate(), OauthContext.oauthInfo.rtExpireTime);
        }
        return oauthInfo != null ? OauthContext.oauthInfo.accessToken : null;
    }

    private static OauthInfo getRefreshAuthInfo() {
        String string = ProjectContext.get("oauth.refreshToken.url");
        if (StringUtil.isEmpty(string)) {
            logger.error("oauth.refreshToken.url is not config in ProjectContext.");
            return null;
        }
        String string2 = string.replace("{refresh_token}", OauthContext.oauthInfo.refreshToken);
        String string3 = HttpClientUtil.get(string2);
        logger.info("oauth info:{}", (Object)string3);
        if (!StringUtil.isEmpty(string3)) {
            return (OauthInfo)JSON.parseObject((String)string3, OauthInfo.class);
        }
        logger.error("refresh token error!,oauth.refreshToken.url {}", (Object)string);
        return null;
    }

    private static OauthInfo getAuthInfo() {
        App app = new App();
        app.appKey = ProjectContext.get("oauth.appKey");
        app.appSecret = ProjectContext.get("oauth.appSecret");
        if (StringUtil.isEmpty(app.appKey)) {
            logger.error("oauth.appKey is not config in ProjectContext.");
            return null;
        }
        if (StringUtil.isEmpty(app.appSecret)) {
            logger.error("oauth.appSecret is not config in ProjectContext.");
            return null;
        }
        String string = ProjectContext.get("oauth.getToken.url");
        if (StringUtil.isEmpty(string)) {
            logger.error("oauth.getToken.url is not config in ProjectContext.");
            return null;
        }
        String string2 = HttpClientUtil.post(string, JSON.toJSONString((Object)app));
        logger.info("oauth info:{}", (Object)string2);
        if (!StringUtil.isEmpty(string2)) {
            return (OauthInfo)JSON.parseObject((String)string2, OauthInfo.class);
        }
        logger.error("get token error!,oauth.getToken.url {}", (Object)string);
        return null;
    }

    public static List<AppResourceCode> getAuthorizedResources() {
        if (oauthInfo == null) {
            logger.error("oauthInfo is null, maybe you need call open method first.");
            return null;
        }
        return OauthContext.oauthInfo.authorizedResources;
    }

    public static void setCurrentAppResourceCode(AppResourceCode appResourceCode) {
        currentAppResourceCodeTl.set(appResourceCode);
    }

    public static AppResourceCode getCurrentAppResourceCode() {
        return currentAppResourceCodeTl.get();
    }
}

