/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.mybatis;

import com.jsmframe.mybatis.Dialect;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;

public abstract class AbstractDialect
implements Dialect {
    protected static Pattern fromPattern = Pattern.compile("\\s+from\\s+", 2);
    protected static Pattern orderByPattern = Pattern.compile("\\s+order\\s+by\\s+", 2);
    protected Properties properties;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public BoundSql createNewBoundSql(MappedStatement mappedStatement, BoundSql boundSql, String string) {
        BoundSql boundSql2 = new BoundSql(mappedStatement.getConfiguration(), string, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
            String string2 = parameterMapping.getProperty();
            if (!boundSql.hasAdditionalParameter(string2)) continue;
            boundSql2.setAdditionalParameter(string2, boundSql.getAdditionalParameter(string2));
        }
        return boundSql2;
    }

    @Override
    public MappedStatement createNewMappedStatement(MappedStatement mappedStatement, BoundSql boundSql, String string) {
        BoundSql boundSql2 = this.createNewBoundSql(mappedStatement, boundSql, string);
        return this.createNewMappedStatement(mappedStatement, this.getSqlSource(boundSql2));
    }

    @Override
    public MappedStatement createNewMappedStatement(MappedStatement mappedStatement, SqlSource sqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(mappedStatement.getConfiguration(), mappedStatement.getId(), sqlSource, mappedStatement.getSqlCommandType());
        builder.resource(mappedStatement.getResource());
        builder.fetchSize(mappedStatement.getFetchSize());
        builder.statementType(mappedStatement.getStatementType());
        builder.keyGenerator(mappedStatement.getKeyGenerator());
        if (mappedStatement.getKeyProperties() != null && mappedStatement.getKeyProperties().length != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : mappedStatement.getKeyProperties()) {
                stringBuilder.append(string).append(",");
            }
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
            builder.keyProperty(stringBuilder.toString());
        }
        builder.timeout(mappedStatement.getTimeout());
        builder.parameterMap(mappedStatement.getParameterMap());
        builder.resultMaps(mappedStatement.getResultMaps());
        builder.resultSetType(mappedStatement.getResultSetType());
        builder.cache(mappedStatement.getCache());
        builder.flushCacheRequired(mappedStatement.isFlushCacheRequired());
        builder.useCache(mappedStatement.isUseCache());
        return builder.build();
    }

    @Override
    public String getSqlBody(String string) {
        Matcher matcher = fromPattern.matcher(string);
        int n = 0;
        if (matcher.find()) {
            n = matcher.end();
        }
        return string.substring(n);
    }

    @Override
    public SqlSource getSqlSource(final BoundSql boundSql) {
        return new SqlSource(){

            public BoundSql getBoundSql(Object object) {
                return boundSql;
            }
        };
    }
}

