/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.jedis;

import com.jsmframe.jedis.JedisDataSource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import redis.clients.jedis.ShardedJedis;

@Repository
public class JedisService {
    private Logger logger = LoggerFactory.getLogger(JedisService.class);
    @Autowired
    private JedisDataSource redisDataSource;

    public void disconnect() {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        shardedJedis.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String set(String string, String string2, int n) {
        String string3 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string3;
        }
        boolean bl = false;
        try {
            string3 = shardedJedis.set(string, string2);
            Long l = shardedJedis.expire(string, n);
            this.logger.debug("expireResult:" + l);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String string, String string2, Date date) {
        String string3 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string3;
        }
        boolean bl = false;
        try {
            string3 = shardedJedis.set(string, string2);
            Long l = shardedJedis.expireAt(string, date.getTime() / 1000L);
            this.logger.debug("expireResult:" + l);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String string, int n, String string2) {
        String string3 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string3;
        }
        boolean bl = false;
        try {
            string3 = shardedJedis.setex(string, n, string2);
            this.logger.debug("expireResult:" + string3);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String string, String string2) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.setnx(string, string2);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String string, String string2) {
        String string3 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string3;
        }
        boolean bl = false;
        try {
            string3 = shardedJedis.set(string, string2);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(String string, Map<String, String> map) {
        String string2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string2;
        }
        boolean bl = false;
        try {
            string2 = shardedJedis.hmset(string, map);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hmget(String string, String ... stringArray) {
        List list = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return list;
        }
        boolean bl = false;
        try {
            list = shardedJedis.hmget(string, stringArray);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String string, String string2, String string3) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.hset(string, string2, string3);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String string, String string2) {
        String string3 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string3;
        }
        boolean bl = false;
        try {
            string3 = shardedJedis.hget(string, string2);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(String string, String ... stringArray) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.hdel(string, stringArray);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string) {
        String string2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string2;
        }
        boolean bl = false;
        try {
            string2 = shardedJedis.get(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String string) {
        Boolean bl = false;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return bl;
        }
        boolean bl2 = false;
        try {
            bl = shardedJedis.exists(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl2 = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type(String string) {
        String string2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string2;
        }
        boolean bl = false;
        try {
            string2 = shardedJedis.type(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String string, int n) {
        this.logger.debug("key {} expire after {}", (Object)string, (Object)n);
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.expire(string, n);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expireAt(String string, long l) {
        Long l2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l2;
        }
        boolean bl = false;
        try {
            l2 = shardedJedis.expireAt(string, l);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(String string) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.ttl(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setbit(String string, long l, boolean bl) {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        boolean bl2 = false;
        if (shardedJedis == null) {
            return bl2;
        }
        boolean bl3 = false;
        try {
            bl2 = shardedJedis.setbit(string, l, bl);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl3 = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl3);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getbit(String string, long l) {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        boolean bl = false;
        if (shardedJedis == null) {
            return bl;
        }
        boolean bl2 = false;
        try {
            bl = shardedJedis.getbit(string, l);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl2 = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setRange(String string, long l, String string2) {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        long l2 = 0L;
        if (shardedJedis == null) {
            return l2;
        }
        boolean bl = false;
        try {
            l2 = shardedJedis.setrange(string, l, string2);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRange(String string, long l, long l2) {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        String string2 = null;
        if (shardedJedis == null) {
            return string2;
        }
        boolean bl = false;
        try {
            string2 = shardedJedis.getrange(string, l, l2);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String string) {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        Long l = null;
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.del(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] lpop(byte[] byArray) {
        byte[] byArray2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return byArray2;
        }
        boolean bl = false;
        try {
            byArray2 = shardedJedis.lpop(byArray);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] rpop(byte[] byArray) {
        byte[] byArray2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return byArray2;
        }
        boolean bl = false;
        try {
            byArray2 = shardedJedis.rpop(byArray);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String string) {
        String string2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string2;
        }
        boolean bl = false;
        try {
            string2 = shardedJedis.lpop(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpop(String string) {
        String string2 = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return string2;
        }
        boolean bl = false;
        try {
            string2 = shardedJedis.rpop(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(String string, String ... stringArray) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.lpush(string, stringArray);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(String string, String ... stringArray) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.rpush(string, stringArray);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(byte[] byArray, byte[] ... byArray2) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.lpush(byArray, byArray2);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(byte[] byArray, byte[] ... byArray2) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.rpush(byArray, byArray2);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(String string) {
        Long l = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return l;
        }
        boolean bl = false;
        try {
            l = shardedJedis.llen(string);
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
            bl = true;
        }
        finally {
            this.redisDataSource.returnResource(shardedJedis, bl);
        }
        return l;
    }

    public boolean lock(String string) {
        return this.lock(string, 1000);
    }

    public synchronized boolean lock(String string, int n) {
        Long l = this.setnx(string, "1");
        boolean bl = true;
        if (l == 0L) {
            int n2 = 0;
            while (true) {
                if ((l = this.setnx(string, "1")) == 1L) {
                    bl = true;
                    break;
                }
                if (n2 == n) {
                    this.logger.error("wait lock time out retry times {}", (Object)n);
                    bl = false;
                    break;
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.error("", (Throwable)interruptedException);
                }
                ++n2;
            }
        }
        this.expire(string, 30);
        return bl;
    }

    public synchronized void unlock(String string) {
        this.del(string);
    }
}

