/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.interceptor;

import com.alibaba.fastjson.JSON;
import com.jsmframe.dao.model.Page;
import com.jsmframe.mybatis.Db2Dialect;
import com.jsmframe.mybatis.Dialect;
import com.jsmframe.mybatis.MysqlDialect;
import com.jsmframe.mybatis.OracleDialect;
import com.jsmframe.mybatis.SqlServer2012Dialect;
import com.jsmframe.mybatis.SqlServerDialect;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageInterceptor
implements Interceptor {
    private static Logger logger = LogUtil.log(PageInterceptor.class);
    private Dialect dialect = new MysqlDialect();
    private static final String MYSQL = "mysql";
    private static final String ORACLE = "oracle";
    private static final String DB2 = "oracle";
    private static final String SQLSERVER = "sqlserver";
    private static final String SQLSERVER2012 = "sqlserver2012";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] objectArray = invocation.getArgs();
        logger.debug("query args:{}", (Object)objectArray.length);
        MappedStatement mappedStatement = (MappedStatement)objectArray[0];
        Object object = objectArray[1];
        BoundSql boundSql = null;
        boundSql = objectArray.length == 4 ? mappedStatement.getBoundSql(object) : (BoundSql)objectArray[5];
        String string = boundSql.getSql();
        if (boundSql.getParameterObject() instanceof Page) {
            Object object2;
            MappedStatement mappedStatement2;
            Page page = (Page)boundSql.getParameterObject();
            String string2 = null;
            Statement statement = null;
            Connection connection = null;
            ResultSet resultSet = null;
            String string3 = null;
            int n = 0;
            try {
                string3 = StringUtil.normalizeSQL(this.dialect.concatCountSql(string));
                logger.debug("countSql: {}", (Object)string3);
                string2 = this.dialect.concatPageSql(string, page.getBeginIndex(), page.getPageSize());
                connection = mappedStatement.getConfiguration().getEnvironment().getDataSource().getConnection();
                statement = connection.prepareStatement(string3);
                mappedStatement2 = this.dialect.createNewBoundSql(mappedStatement, boundSql, string3);
                object2 = new DefaultParameterHandler(mappedStatement, object, (BoundSql)mappedStatement2);
                object2.setParameters((PreparedStatement)statement);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
            catch (Exception exception) {
                logger.error("count records for page error!sql:" + string, (Throwable)exception);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    logger.error("count records for page close conn error!sql:" + string, (Throwable)exception);
                }
            }
            page.setTotalCount(n);
            mappedStatement2 = this.dialect.createNewMappedStatement(mappedStatement, boundSql, string2);
            invocation.getArgs()[0] = mappedStatement2;
            object2 = invocation.proceed();
            page.setList((List)object2);
            return object2;
        }
        return invocation.proceed();
    }

    public Object plugin(Object object) {
        return Plugin.wrap((Object)object, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        logger.debug("properties:{}", (Object)JSON.toJSONString((Object)properties));
        String string = properties.getProperty("dbDialect");
        if (MYSQL.equalsIgnoreCase(string)) {
            this.dialect = new MysqlDialect();
        } else if ("oracle".equalsIgnoreCase(string)) {
            this.dialect = new OracleDialect();
        } else if ("oracle".equalsIgnoreCase(string)) {
            this.dialect = new Db2Dialect();
        } else if (SQLSERVER.equalsIgnoreCase(string)) {
            this.dialect = new SqlServerDialect();
        } else if (SQLSERVER2012.equalsIgnoreCase(string)) {
            this.dialect = new SqlServer2012Dialect();
        } else {
            logger.warn("dbDialect not specify, use default:mysql");
        }
    }
}

