/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.interceptor;

import com.alibaba.fastjson.JSON;
import com.jsmframe.annotation.AuthType;
import com.jsmframe.annotation.RestAnn;
import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.context.ProjectContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.jedis.JedisService;
import com.jsmframe.oauth.OauthContext;
import com.jsmframe.oauth.model.AppResourceCode;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.session.Session;
import com.jsmframe.utils.BlowFishUtil;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.HttpClientUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import com.jsmframe.utils.WebUtil;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class JsmRestInterceptor
extends HandlerInterceptorAdapter {
    private static Logger logger = LogUtil.log(JsmRestInterceptor.class);

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
        httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpServletResponse.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        httpServletResponse.setHeader("Access-Control-Max-Age", "3600");
        httpServletResponse.setHeader("Access-Control-Allow-Headers", "x-requested-with");
        HandlerMethod handlerMethod = (HandlerMethod)object;
        Method method = handlerMethod.getMethod();
        RestAnn restAnn = method.getAnnotation(RestAnn.class);
        if (restAnn == null) {
            return true;
        }
        RestResp<String> restResp = new RestResp();
        if (!restAnn.authType().equals((Object)AuthType.NONE)) {
            restResp = this.checkAuth(httpServletRequest, restAnn);
        }
        if (!restResp.isOK()) {
            this.handleError(httpServletRequest, httpServletResponse, restResp);
            return false;
        }
        WebContext.setRequest(httpServletRequest);
        WebContext.setResponse(httpServletResponse);
        return true;
    }

    private RestResp<String> checkAuth(HttpServletRequest httpServletRequest, RestAnn restAnn) {
        RestResp<String> restResp = this.checkSession(httpServletRequest, restAnn);
        if (!restResp.isOK()) {
            return restResp;
        }
        return restResp;
    }

    private RestResp<String> checkSession(HttpServletRequest httpServletRequest, RestAnn restAnn) {
        String string = httpServletRequest.getHeader("at");
        String string2 = httpServletRequest.getHeader("ht");
        if (StringUtil.isEmpty(string) && StringUtil.isEmpty(string2)) {
            string = httpServletRequest.getParameter("at");
            string2 = httpServletRequest.getParameter("ht");
        }
        String string3 = httpServletRequest.getHeader("Authorization");
        logger.debug("checkSession, auth type {},at {}, ht {},authorization {}", new Object[]{restAnn.authType(), string, string2, string3});
        RestResp<String> restResp = new RestResp<String>();
        String string4 = null;
        if (AuthType.OAUTH.equals((Object)restAnn.authType()) && !StringUtil.isEmpty(string3)) {
            String string5;
            string4 = string3.replace("Bearer", "").trim();
            boolean bl = this.verifyOauthToken(string4, string5 = restAnn.permission());
            if (!bl) {
                restResp.setPair(BasePairConsts.AUTH_FAIL);
            }
            return restResp;
        }
        if (!StringUtil.isEmpty(string) && !StringUtil.isEmpty(string2)) {
            string4 = AuthType.APP.equals((Object)restAnn.authType()) ? this.verifyAppApi(string, string2, httpServletRequest) : this.verifyWebApi(string, string2, httpServletRequest);
        }
        if (ProjectContext.isDevModel() && StringUtil.isEmpty(string4) && StringUtil.isEmpty(string4 = httpServletRequest.getHeader("token"))) {
            string4 = httpServletRequest.getParameter("_token");
        }
        if (StringUtil.isEmpty(string4)) {
            restResp.setPair(BasePairConsts.AUTH_FAIL);
        } else {
            Session session = new Session(string4);
            if (session.isExpire()) {
                restResp.setPair(BasePairConsts.NO_LOGIN);
            } else {
                session.live();
                httpServletRequest.setAttribute("jedis_session_key", (Object)session);
            }
        }
        if (!StringUtil.isEmpty(restAnn.permission()) && !WebUtil.hasPermissions(restAnn.permission())) {
            restResp.setPair(BasePairConsts.NO_PERMISSION);
        }
        return restResp;
    }

    private String getVerifyOauthTokenResult(String string, String string2) {
        String string3 = ProjectContext.get("oauth.verifyToken.url");
        if (StringUtil.isEmpty(string3)) {
            logger.error("oauth.verifyToken.url not found, in ProjectContext!");
            return null;
        }
        try {
            string3 = string3.replace("{access_token}", string);
            string3 = string3.replace("{resource_code}", string2);
            String string4 = HttpClientUtil.get(string3);
            logger.debug("res:{}", (Object)string4);
            return string4;
        }
        catch (Exception exception) {
            logger.error("getVerifyOauthTokenResult error:" + string3, (Throwable)exception);
            return null;
        }
    }

    private boolean verifyOauthToken(String string, String string2) {
        try {
            Object object;
            JedisService jedisService = SpringContext.getBean(JedisService.class);
            String string3 = string + "_" + string2;
            String string4 = jedisService.get(string3);
            if (StringUtil.isEmpty(string4)) {
                string4 = this.getVerifyOauthTokenResult(string, string2);
                object = ProjectContext.getAsInteger("oauth.verifyToken.expireTime");
                if (object == null) {
                    object = 5;
                    logger.warn("oauth.verifyToken.expireTime not config, use default:{}", object);
                }
                jedisService.setex(string3, (Integer)object, string4 + "");
            }
            object = JSON.parseObject((String)string4);
            if (BasePairConsts.OK.getCode().equals(object.getString("code"))) {
                String string5 = object.getString("result");
                AppResourceCode appResourceCode = (AppResourceCode)JSON.parseObject((String)string5, AppResourceCode.class);
                OauthContext.setCurrentAppResourceCode(appResourceCode);
                return true;
            }
            logger.error("verifyOauthToken token:{} , resourceCode:{}", (Object)string, (Object)string2);
            return false;
        }
        catch (Exception exception) {
            logger.error("verifyOauthToken error!", (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RestResp<String> restResp) {
        try (PrintWriter printWriter = null;){
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("application/json; charset=UTF-8");
            printWriter = httpServletResponse.getWriter();
            logger.error("error:{}", restResp);
            printWriter.print(restResp.toString());
        }
    }

    private String verifyWebApi(String string, String string2, HttpServletRequest httpServletRequest) {
        logger.debug("auth: {}", (Object)string);
        logger.debug("hash: {}", (Object)string2);
        String string3 = null;
        try {
            String string4 = EncryptUtil.base64Decode(string);
            if (string4 == null || !string4.contains("_")) {
                logger.error("illegal auth: {}", (Object)string);
                return null;
            }
            String[] stringArray = string4.split("_");
            string3 = stringArray[0];
            String string5 = stringArray[1];
            Long l = Long.valueOf(string5);
            long l2 = DateUtil.currentTime();
            Long l3 = Math.abs(l2 - l);
            Long l4 = ProjectContext.getAsLong("at.expire.time");
            if (l4 == null) {
                l4 = 60000L;
            }
            if (l3 > l4) {
                logger.error("sTime {} - ctime {} = {}", new Object[]{l2, l, l3});
                return null;
            }
            String string6 = EncryptUtil.base64Encode(string3 + "_" + string5);
            if (!string6.equals(string)) {
                logger.error("sAuth {} != auth {}", new Object[]{string6, string});
                return null;
            }
            String string7 = EncryptUtil.md5(string3 + "_" + string5);
            if (!string7.equals(string2)) {
                logger.error("sHash {} != hash {}", new Object[]{string7, string2});
                return null;
            }
            httpServletRequest.setAttribute("token", (Object)string3);
        }
        catch (Exception exception) {
            logger.error("verifyWebApi error!", (Throwable)exception);
            return null;
        }
        return string3;
    }

    private String verifyAppApi(String string, String string2, HttpServletRequest httpServletRequest) {
        logger.debug("auth: {}", (Object)string);
        logger.debug("hash: {}", (Object)string2);
        String string3 = null;
        try {
            String string4 = BlowFishUtil.dec(string);
            if (string4 == null || !string4.contains(",")) {
                logger.error("illegal auth: {}", (Object)string);
                return null;
            }
            String[] stringArray = string4.split(",");
            string3 = stringArray[0];
            String string5 = stringArray[1];
            Long l = Long.valueOf(string5);
            long l2 = DateUtil.currentTime();
            Long l3 = Math.abs(l2 - l);
            Long l4 = ProjectContext.getAsLong("at.expire.time");
            if (l4 == null) {
                l4 = 60000L;
            }
            if (l3 > l4) {
                logger.error("sTime {} - ctime {} = {}", new Object[]{l2, l, l3});
                return null;
            }
            String string6 = BlowFishUtil.enc(string3 + "," + string5);
            if (!string6.equals(string)) {
                logger.error("sAuth {} != auth {}", new Object[]{string6, string});
                return null;
            }
            String string7 = EncryptUtil.md5(string3 + "," + string5);
            if (!string7.equals(string2)) {
                logger.error("sHash {} != hash {}", new Object[]{string7, string2});
                return null;
            }
            httpServletRequest.setAttribute("token", (Object)string3);
        }
        catch (Exception exception) {
            logger.error("verifyAppApi error!", (Throwable)exception);
            return null;
        }
        return string3;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) throws Exception {
    }
}

