/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.interceptor;

import com.jsmframe.context.WebContext;
import com.jsmframe.exception.BaseException;
import com.jsmframe.utils.LogUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.util.NestedServletException;

public class JsmFilter
extends OncePerRequestFilter {
    private Logger logger = LogUtil.log(((Object)((Object)this)).getClass());
    private String encoding;
    private boolean forceEncoding = false;

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setForceEncoding(boolean bl) {
        this.forceEncoding = bl;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        this.logger.debug(string + " " + httpServletRequest.getRequestURI());
        if (this.encoding != null && (this.forceEncoding || httpServletRequest.getCharacterEncoding() == null)) {
            httpServletRequest.setCharacterEncoding(this.encoding);
            if (this.forceEncoding) {
                httpServletResponse.setCharacterEncoding(this.encoding);
            }
        }
        WebContext.setRequest(httpServletRequest);
        WebContext.setResponse(httpServletResponse);
        try {
            if (string.equals(RequestMethod.OPTIONS.name())) {
                String string2 = "request method not support.";
                this.logger.warn("request method not support {}", (Object)string);
                WebContext.toErrorPage(string2);
            } else {
                this.logger.debug("before fc.doFilter");
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                this.logger.debug("after fc.doFilter");
            }
        }
        catch (NestedServletException nestedServletException) {
            String string3 = "\u8bbf\u95ee" + httpServletRequest.getRequestURL().toString() + "\u51fa\u9519\uff01";
            this.logger.error(string3, (Throwable)nestedServletException);
            if (nestedServletException.getCause() instanceof BaseException) {
                WebContext.toErrorPage(nestedServletException.getCause().getMessage());
            } else if (nestedServletException.getCause() instanceof MaxUploadSizeExceededException) {
                WebContext.toErrorPage("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236\uff01");
            } else {
                WebContext.toErrorPage("\u7cfb\u7edf\u51fa\u9519\uff01");
            }
            this.logger.error(string3, (Throwable)nestedServletException);
        }
        catch (Exception exception) {
            String string4 = "\u8bbf\u95ee" + httpServletRequest.getRequestURL().toString() + "\u51fa\u9519\uff01";
            this.logger.error(string4, (Throwable)exception);
            WebContext.toErrorPage(string4);
        }
        WebContext.removeRequest();
        WebContext.removeResponse();
    }
}

