/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.excel;

import com.jsmframe.excel.ExcelField;
import com.jsmframe.utils.BeanUtil;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static Logger logger = LogUtil.log(ExcelUtil.class);
    private static final String OFFICE_EXCEL_XLS = ".xls";
    private static final String OFFICE_EXCEL_XLSX = ".xlsx";
    private static final String DEFAULT_KEY = "default";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Workbook writeToTemplate(InputStream inputStream, int n, int n2, List<T> list) {
        XSSFWorkbook xSSFWorkbook = null;
        try {
            xSSFWorkbook = new XSSFWorkbook(inputStream);
            Workbook workbook = ExcelUtil.writeWorkbook((Workbook)xSSFWorkbook, n, n2, list);
            return workbook;
        }
        catch (Exception exception) {
            logger.error("writeToTemplate error!", (Throwable)exception);
            Workbook workbook = null;
            return workbook;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("writeToTemplate close templateIs error!", (Throwable)iOException);
                }
            }
        }
    }

    public static <T> Workbook writeToNew(List<T> list) {
        XSSFWorkbook xSSFWorkbook = null;
        try {
            xSSFWorkbook = new XSSFWorkbook();
            if (list == null || list.isEmpty()) {
                logger.warn("empty dataList!");
                return xSSFWorkbook;
            }
            Sheet sheet = xSSFWorkbook.createSheet();
            Row row = sheet.createRow(0);
            Field[] fieldArray = list.get(0).getClass().getFields();
            int n = 0;
            Font font = xSSFWorkbook.createFont();
            font.setBold(true);
            CellStyle cellStyle = xSSFWorkbook.createCellStyle();
            cellStyle.setFont(font);
            for (Field field : fieldArray) {
                Cell cell = row.createCell(n++);
                cell.setCellStyle(cellStyle);
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                if (excelField == null || StringUtil.isEmpty(excelField.name())) {
                    cell.setCellValue(field.getName());
                    continue;
                }
                cell.setCellValue(excelField.name());
            }
            return ExcelUtil.writeWorkbook((Workbook)xSSFWorkbook, 0, 1, list);
        }
        catch (Exception exception) {
            logger.error("writeToNew error!", (Throwable)exception);
            return null;
        }
    }

    private static <T> Workbook writeWorkbook(Workbook workbook, int n, int n2, List<T> list) {
        CellStyle cellStyle;
        Sheet sheet = workbook.getSheetAt(n);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Map<String, String>> hashMap2 = new HashMap<String, Map<String, String>>();
        if (n2 == 1) {
            cellStyle = sheet.getRow(0);
            for (int i = 0; i < cellStyle.getLastCellNum(); ++i) {
                hashMap.put(cellStyle.getCell(i).getStringCellValue(), i);
            }
        }
        cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        for (T t : list) {
            Row row = sheet.createRow(n2++);
            Field[] fieldArray = t.getClass().getFields();
            int n3 = 0;
            for (Field field : fieldArray) {
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                if (excelField != null && excelField.ignore()) continue;
                Integer n4 = (Integer)hashMap.get(field.getName());
                if (excelField != null && !StringUtil.isEmpty(excelField.name())) {
                    n4 = (Integer)hashMap.get(excelField.name());
                }
                if (n4 == null) {
                    n4 = n3;
                }
                Cell cell = row.createCell(n4.intValue());
                Object object = BeanUtil.getFieldValue(field, t);
                if (object == null) continue;
                if (object instanceof Date) {
                    if (StringUtil.isEmpty(excelField.format())) {
                        cell.setCellValue(DateUtil.format((Date)object, "yyyy-MM-dd"));
                    } else {
                        cell.setCellValue(DateUtil.format((Date)object, excelField.format()));
                    }
                } else {
                    cell.setCellType(excelField.cellType());
                    String string = object.toString();
                    if (!StringUtil.isEmpty(excelField.replaceRule()) && excelField.replaceRule().contains("|")) {
                        string = ExcelUtil.findReplaceValReverse(hashMap2, excelField.replaceRule(), field.getName(), string);
                    }
                    cell.setCellValue(string);
                    cell.setCellStyle(cellStyle);
                }
                ++n3;
            }
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readExcel(MultipartFile multipartFile, int n, Class<T> clazz, int n2) {
        if (multipartFile.isEmpty()) {
            return null;
        }
        String string = multipartFile.getOriginalFilename().toLowerCase();
        InputStream inputStream = null;
        HSSFWorkbook hSSFWorkbook = null;
        try {
            inputStream = multipartFile.getInputStream();
            if (string.toLowerCase().endsWith(OFFICE_EXCEL_XLS)) {
                hSSFWorkbook = new HSSFWorkbook(inputStream);
            } else if (string.toLowerCase().endsWith(OFFICE_EXCEL_XLSX)) {
                hSSFWorkbook = new XSSFWorkbook(inputStream);
            } else {
                logger.error("not excel file can't read.");
                List<T> list = null;
                return list;
            }
            List<T> list = ExcelUtil.readWorkbook((Workbook)hSSFWorkbook, n, clazz, n2);
            return list;
        }
        catch (Exception exception) {
            logger.error("readExcel error! file:" + string, (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("readXlsx close fis error!", (Throwable)iOException);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readExcel(String string, int n, Class<T> clazz, int n2) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        HSSFWorkbook hSSFWorkbook = null;
        try {
            fileInputStream = new FileInputStream(file);
            if (string.toLowerCase().endsWith(OFFICE_EXCEL_XLS)) {
                hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
            } else if (string.toLowerCase().endsWith(OFFICE_EXCEL_XLSX)) {
                hSSFWorkbook = new XSSFWorkbook((InputStream)fileInputStream);
            } else {
                logger.error("not excel file can't read.");
                List<T> list = null;
                return list;
            }
            List<T> list = ExcelUtil.readWorkbook((Workbook)hSSFWorkbook, n, clazz, n2);
            return list;
        }
        catch (Exception exception) {
            logger.error("readExcel error! file:" + string, (Throwable)exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("readExcel close fis error!", (Throwable)iOException);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> readWorkbook(Workbook workbook, int n, Class<T> clazz, int n2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        try {
            Sheet sheet = workbook.getSheetAt(n);
            logger.info("read sheetIdx:{},row number:{}", (Object)n, (Object)sheet.getLastRowNum());
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            if (n2 == 1) {
                Row row = sheet.getRow(0);
                for (int i = 0; i < row.getLastCellNum(); ++i) {
                    hashMap2.put(row.getCell(i).getStringCellValue(), i);
                }
            }
            for (int i = n2; i <= sheet.getLastRowNum(); ++i) {
                T t = clazz.newInstance();
                List<String> list = ExcelUtil.readRowAsList(sheet.getRow(i), 0);
                if (ExcelUtil.isEmptyRow(list)) {
                    break;
                }
                Field[] fieldArray = t.getClass().getFields();
                int n3 = 0;
                for (Field field : fieldArray) {
                    hashMap2.put(field.getName(), n3++);
                }
                for (Field field : fieldArray) {
                    Integer n4;
                    String string = null;
                    ExcelField excelField = field.getAnnotation(ExcelField.class);
                    if (excelField != null) {
                        string = excelField.name();
                    }
                    if (StringUtil.isEmpty(string)) {
                        string = field.getName();
                    }
                    if ((n4 = (Integer)hashMap2.get(string)) == null || n4 >= list.size()) continue;
                    String string2 = list.get(n4);
                    if (excelField != null && !StringUtil.isEmpty(excelField.replaceRule()) && excelField.replaceRule().contains("|")) {
                        string2 = ExcelUtil.findReplaceVal(hashMap, excelField.replaceRule(), string, string2);
                    }
                    if (StringUtil.isEmpty(string2)) continue;
                    BeanUtil.setFieldValue(t, field, string2);
                }
                arrayList.add(t);
            }
        }
        catch (Exception exception) {
            logger.error("readWorkbook error!", (Throwable)exception);
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException iOException) {
                    logger.error("readWorkbook close workBook error!", (Throwable)iOException);
                }
            }
        }
        return arrayList;
    }

    private static String findReplaceVal(Map<String, Map<String, String>> map, String string, String string2, String string3) {
        Object object;
        if (!map.containsKey(string2)) {
            String[] stringArray;
            object = new HashMap();
            for (String string4 : stringArray = string.split(";")) {
                String[] stringArray2 = string4.split("\\|");
                if (stringArray2.length > 1) {
                    object.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                object.put(stringArray2[0], null);
            }
            map.put(string2, (Map<String, String>)object);
        }
        if ((object = map.get(string2).get(string3)) == null && map.get(string2).containsKey(DEFAULT_KEY)) {
            object = map.get(string2).get(DEFAULT_KEY);
        }
        return object == null ? string3 : object;
    }

    private static String findReplaceValReverse(Map<String, Map<String, String>> map, String string, String string2, String string3) {
        Object object;
        if (!map.containsKey(string2)) {
            String[] stringArray;
            object = new HashMap();
            for (String string4 : stringArray = string.split(";")) {
                String[] stringArray2 = string4.split("\\|");
                if (stringArray2.length <= 1) continue;
                object.put(stringArray2[1], stringArray2[0]);
            }
            map.put(string2, (Map<String, String>)object);
        }
        return (object = map.get(string2).get(string3)) == null ? string3 : object;
    }

    private static boolean isEmptyRow(List<String> list) {
        for (String string : list) {
            if (StringUtil.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static List<String> readRowAsList(Row row, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = n; i < row.getLastCellNum(); ++i) {
            arrayList.add(ExcelUtil.getCellValue(row.getCell(i)));
        }
        return arrayList;
    }

    public static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 2) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == 0) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return cell.toString();
    }

    public static List<CellRangeAddress> getCombineCell(Sheet sheet) {
        ArrayList<CellRangeAddress> arrayList = new ArrayList<CellRangeAddress>();
        int n = sheet.getNumMergedRegions();
        for (int i = 0; i < n; ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            arrayList.add(cellRangeAddress);
        }
        return arrayList;
    }

    public static String isCombineCell(List<CellRangeAddress> list, Cell cell, Sheet sheet) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        for (CellRangeAddress cellRangeAddress : list) {
            n = cellRangeAddress.getFirstColumn();
            n2 = cellRangeAddress.getLastColumn();
            n3 = cellRangeAddress.getFirstRow();
            n4 = cellRangeAddress.getLastRow();
            if (cell.getRowIndex() >= n3 && cell.getRowIndex() <= n4) {
                if (cell.getColumnIndex() < n || cell.getColumnIndex() > n2) continue;
                Row row = sheet.getRow(n3);
                Cell cell2 = row.getCell(n);
                string = ExcelUtil.getCellValue(cell2);
                break;
            }
            string = "";
        }
        return string;
    }

    public static String getMergedRegionValue(Sheet sheet, int n, int n2) {
        int n3 = sheet.getNumMergedRegions();
        for (int i = 0; i < n3; ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            int n4 = cellRangeAddress.getFirstColumn();
            int n5 = cellRangeAddress.getLastColumn();
            int n6 = cellRangeAddress.getFirstRow();
            int n7 = cellRangeAddress.getLastRow();
            if (n < n6 || n > n7 || n2 < n4 || n2 > n5) continue;
            Row row = sheet.getRow(n6);
            Cell cell = row.getCell(n4);
            return ExcelUtil.getCellValue(cell);
        }
        return null;
    }

    public static boolean isMergedRegion(Sheet sheet, int n, int n2) {
        int n3 = sheet.getNumMergedRegions();
        for (int i = 0; i < n3; ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            int n4 = cellRangeAddress.getFirstColumn();
            int n5 = cellRangeAddress.getLastColumn();
            int n6 = cellRangeAddress.getFirstRow();
            int n7 = cellRangeAddress.getLastRow();
            if (n < n6 || n > n7 || n2 < n4 || n2 > n5) continue;
            return true;
        }
        return false;
    }
}

