/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.dao.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.jsmframe.annotation.FieldAnn;
import com.jsmframe.annotation.FieldType;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.EncryptUtil;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.StringUtil;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class Page<T> {
    private static Logger logger = LogUtil.log(Page.class);
    @ApiParam(hidden=true)
    private List<T> list;
    @FieldAnn(required=true, type=FieldType.NUMBER)
    private int pageNo = 1;
    @FieldAnn(required=true, type=FieldType.NUMBER)
    private int pageSize = 15;
    @ApiParam(hidden=true)
    private long totalCount = 0L;
    private String queryString = "";
    @ApiParam(hidden=true)
    private Map<String, Object> queryMap;
    @ApiParam(hidden=true)
    @JSONField(serialize=false)
    private String dbDialect = null;

    public Page() {
    }

    public Page(int n) {
        this.pageSize = n;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void convertParamToInteger(String string) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Integer)) {
            this.getQueryMap().put(string, StringUtil.toInteger(object.toString()));
        }
    }

    public void convertParamToLong(String string) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Long)) {
            this.getQueryMap().put(string, StringUtil.toLong(object.toString()));
        }
    }

    public void convertParamToFloat(String string) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Float)) {
            this.getQueryMap().put(string, StringUtil.toFloat(object.toString()));
        }
    }

    public void convertParamToDate(String string) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Date)) {
            this.getQueryMap().put(string, DateUtil.parse(object.toString()));
        }
    }

    public void convertParamToDateOfBegin(String string) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Date)) {
            Date date = DateUtil.parse(object.toString());
            this.getQueryMap().put(string, DateUtil.dayOfBegin(date));
        }
    }

    public void convertParamToDateOfEnd(String string) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Date)) {
            Date date = DateUtil.parse(object.toString());
            this.getQueryMap().put(string, DateUtil.dayOfEnd(date));
        }
    }

    public void convertParamToDate(String string, String string2) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Date)) {
            this.getQueryMap().put(string, DateUtil.parse(object.toString(), string2));
        }
    }

    public void convertParamToDateOfBegin(String string, String string2) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Date)) {
            Date date = DateUtil.parse(object.toString(), string2);
            this.getQueryMap().put(string, DateUtil.dayOfBegin(date));
        }
    }

    public void convertParamToDateOfEnd(String string, String string2) {
        Object object = this.getQueryMap().get(string);
        if (object != null && !(object instanceof Date)) {
            Date date = DateUtil.parse(object.toString(), string2);
            this.getQueryMap().put(string, DateUtil.dayOfEnd(date));
        }
    }

    public void setParam(String string, Object object) {
        this.getQueryMap().put(string, object);
    }

    public Map<String, Object> getQueryMap() {
        if (this.queryMap != null) {
            return this.queryMap;
        }
        if (!StringUtil.isEmpty(this.queryString)) {
            try {
                String[] stringArray;
                this.queryMap = new HashMap<String, Object>();
                for (String string : stringArray = this.queryString.split("&")) {
                    String[] stringArray2 = string.split("=");
                    if (stringArray2.length < 2) continue;
                    this.queryMap.put(stringArray2[0], StringUtil.trim(EncryptUtil.urlDecode(StringUtil.trim(stringArray2[1]))));
                }
            }
            catch (Exception exception) {
                logger.error("queryString parse map error!" + this.queryString, (Throwable)exception);
                this.queryMap = new HashMap<String, Object>();
            }
        } else {
            this.queryMap = new HashMap<String, Object>();
        }
        return this.queryMap;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int n) {
        this.pageNo = n < 1 ? 1 : n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n) {
        this.pageSize = n < 1 ? 15 : n;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long l) {
        this.totalCount = l;
    }

    public long getTotalPage() {
        if (this.totalCount <= 0L) {
            return 1L;
        }
        long l = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++l;
        }
        return l;
    }

    public boolean isHasPrevPage() {
        return this.pageNo - 1 >= 1;
    }

    public int getPrevPage() {
        return this.isHasPrevPage() ? this.pageNo - 1 : this.pageNo;
    }

    public boolean isHasNextPage() {
        return (long)(this.pageNo + 1) <= this.getTotalPage();
    }

    public int getNextPage() {
        return this.isHasNextPage() ? this.pageNo + 1 : this.pageNo;
    }

    public int getBeginIndex() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public String getDbDialect() {
        return this.dbDialect;
    }

    public void setDbDialect(String string) {
        this.dbDialect = string;
    }
}

