/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.context;

import com.alibaba.fastjson.JSON;
import com.jsmframe.consts.BasePairConsts;
import com.jsmframe.context.ProjectContext;
import com.jsmframe.rest.resp.RestResp;
import com.jsmframe.session.Session;
import com.jsmframe.session.SessionUser;
import com.jsmframe.utils.DateUtil;
import com.jsmframe.utils.LogUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;

public class WebContext {
    private static Logger logger = LogUtil.log(WebContext.class);
    private static ThreadLocal<HttpServletRequest> reqTL = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> resTL = new ThreadLocal();
    private static ThreadLocal<String> jspPath = new ThreadLocal();
    private static String contextPath;
    private static String realPath;

    public static void setRequest(HttpServletRequest httpServletRequest) {
        reqTL.set(httpServletRequest);
    }

    public static HttpServletRequest getRequest() {
        if (reqTL.get() != null) {
            return reqTL.get();
        }
        return WebContext.getJspRequest();
    }

    private static HttpServletRequest getJspRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes == null ? null : servletRequestAttributes.getRequest();
    }

    public static Session currentSession() {
        HttpServletRequest httpServletRequest = WebContext.getRequest();
        return (Session)(httpServletRequest == null ? null : httpServletRequest.getAttribute("jedis_session_key"));
    }

    public static void removeRequest() {
        reqTL.remove();
    }

    public static void setResponse(HttpServletResponse httpServletResponse) {
        resTL.set(httpServletResponse);
    }

    public static HttpServletResponse getResponse() {
        if (resTL.get() != null) {
            return resTL.get();
        }
        return WebContext.getJspResponse();
    }

    public static HttpServletResponse getJspResponse() {
        ServletWebRequest servletWebRequest = (ServletWebRequest)RequestContextHolder.getRequestAttributes();
        return servletWebRequest == null ? null : servletWebRequest.getResponse();
    }

    public static void removeResponse() {
        resTL.remove();
    }

    public static void redirect(String string) throws IOException {
        WebContext.getResponse().sendRedirect(WebContext.getContextPath() + string);
    }

    public static void toErrorPage(String string) {
        try {
            if (WebContext.isAjax() || WebContext.currentSession() == null || WebContext.isRest()) {
                WebContext.sendAjaxError(string);
            } else {
                WebContext.redirect(ProjectContext.get("error.url"));
            }
        }
        catch (Exception exception) {
            logger.error("redirect error page fail!", (Throwable)exception);
        }
    }

    private static boolean isRest() {
        String string = WebContext.getRequest().getContextPath() + "/rest";
        return WebContext.getRequest().getRequestURI().startsWith(string);
    }

    private static void sendAjaxError(String string) {
        RestResp restResp = new RestResp();
        restResp.setPair(BasePairConsts.ERROR);
        restResp.result = string;
        try {
            WebContext.getResponse().addHeader("Content-Type", "text/json;charset=UTF-8");
            WebContext.getResponse().addHeader("Content-Type", "application/json;charset=UTF-8");
            WebContext.getResponse().getWriter().write(JSON.toJSONString(restResp));
        }
        catch (IOException iOException) {
            logger.error("sendAjaxError error!", (Throwable)iOException);
        }
    }

    public static String getRealPath() {
        return realPath;
    }

    public static void setRealPath(String string) {
        realPath = string;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static void setContextPath(String string) {
        contextPath = string;
    }

    public static String realPath2ContextPath(String string) {
        return WebContext.getContextPath() + "/download?fileName=" + string;
    }

    public static String realPath2ContextPath2(String string) {
        logger.info("realPath:" + string);
        return WebContext.getContextPath() + "/download?fileName=" + string;
    }

    public static String getRandomFileName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("_").append(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
        stringBuilder.append("_").append(new Random().nextInt(1000)).append(".").append(string2);
        return stringBuilder.toString();
    }

    public static String saveExcel(HSSFWorkbook hSSFWorkbook) throws IOException {
        String string = WebContext.getRandomFileName("temp", "xls");
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        hSSFWorkbook.write((OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        return string.substring(string.lastIndexOf("\\") + 1);
    }

    public static SessionUser currentUser() {
        Session session = WebContext.currentSession();
        if (session == null) {
            return null;
        }
        return session.getSessionUser();
    }

    public static List<String> currentPermissions() {
        SessionUser sessionUser = WebContext.currentUser();
        if (sessionUser == null) {
            return null;
        }
        return sessionUser.getPermissions();
    }

    public static List<Long> currentRoles() {
        SessionUser sessionUser = WebContext.currentUser();
        if (sessionUser == null) {
            return null;
        }
        return sessionUser.getRoles();
    }

    public static boolean isAjax() {
        String string = WebContext.getRequest().getHeader("X-Requested-With");
        return "XMLHttpRequest".equals(string);
    }

    public static String getRmoteIp() {
        HttpServletRequest httpServletRequest = WebContext.getRequest();
        String string = httpServletRequest.getHeader("x-forwarded-for");
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string;
    }

    public static void setJspPath(String string) {
        jspPath.set(string);
    }

    public static String getJspPath() {
        String string = jspPath.get();
        jspPath.remove();
        return string;
    }

    public static String getBackUrl() {
        if ("GET".equals(WebContext.getRequest().getMethod())) {
            return WebContext.getActionUri();
        }
        String string = WebContext.getRequest().getHeader("REFERER");
        return string.substring(string.indexOf("=") + 1);
    }

    public static byte[] getRequestPostBytes(HttpServletRequest httpServletRequest) {
        try {
            int n;
            int n2 = httpServletRequest.getContentLength();
            if (n2 < 0) {
                return null;
            }
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2 && (n = httpServletRequest.getInputStream().read(byArray, i, n2 - i)) != -1; i += n) {
            }
            return byArray;
        }
        catch (IOException iOException) {
            logger.error("getRequestPostBytes error!", (Throwable)iOException);
            return null;
        }
    }

    public static String getRequestPostStr(HttpServletRequest httpServletRequest) {
        try {
            byte[] byArray = WebContext.getRequestPostBytes(httpServletRequest);
            String string = httpServletRequest.getCharacterEncoding();
            if (string == null) {
                string = "UTF-8";
            }
            if (byArray != null) {
                return new String(byArray, string);
            }
        }
        catch (Exception exception) {
            logger.error("getRequestPostStr error!", (Throwable)exception);
        }
        return null;
    }

    public static String getActionUri() {
        return WebContext.getRequest().getRequestURI().substring(WebContext.getContextPath().length());
    }
}

