/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.context;

import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContext.checkApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String string) {
        SpringContext.checkApplicationContext();
        return (T)applicationContext.getBean(string);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContext.checkApplicationContext();
        Map map = applicationContext.getBeansOfType(clazz);
        if (map != null && !map.isEmpty()) {
            return (T)map.values().iterator().next();
        }
        return null;
    }

    public static String getMessage(String string, Object ... objectArray) {
        return SpringContext.getMessage(Locale.CHINA, string, objectArray);
    }

    public static String getMessage(Locale locale, String string, Object ... objectArray) {
        return applicationContext.getMessage(string, objectArray, locale);
    }

    private static void checkApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u672a\u6ce8\u5165,\u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder");
        }
    }
}

