/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.context;

import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.PropUtil;
import com.jsmframe.utils.StringUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;
import org.slf4j.Logger;

public class ProjectContext {
    private static Logger logger = LogUtil.log(ProjectContext.class);
    private static boolean devModel = true;
    private static boolean jedisSession = false;
    private static String propFile = "project.properties";
    private static Properties properties;

    public static String get(String string) {
        if (devModel || properties == null) {
            properties = PropUtil.getProperties(propFile);
        }
        return properties.getProperty(string);
    }

    public static boolean isDevModel() {
        return devModel;
    }

    public static boolean isJedisSession() {
        return jedisSession;
    }

    public static Integer getAsInteger(String string) {
        try {
            String string2 = ProjectContext.get(string);
            if (!StringUtil.isEmpty(string2)) {
                return Integer.valueOf(string2);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
        catch (Exception exception) {
            logger.error("getAsInteter error! key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
    }

    public static Long getAsLong(String string) {
        try {
            String string2 = ProjectContext.get(string);
            if (!StringUtil.isEmpty(string2)) {
                return Long.valueOf(string2);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
        catch (Exception exception) {
            logger.error("getAsLong error! key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
    }

    public static Boolean getAsBoolean(String string) {
        try {
            String string2 = ProjectContext.get(string);
            if (!StringUtil.isEmpty(string2)) {
                return Boolean.valueOf(string2);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
        catch (Exception exception) {
            logger.error("getAsBoolean error! key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
    }

    public static void init() {
        devModel = ProjectContext.getAsBoolean("dev.model");
        jedisSession = ProjectContext.getAsBoolean("jedis.session");
        logger.info("devModel:{}", (Object)devModel);
        logger.info("jedisSession:{}", (Object)jedisSession);
        Properties properties = System.getProperties();
        String string = ProjectContext.properties.getProperty("http.proxyHost");
        String string2 = ProjectContext.properties.getProperty("http.proxyPort");
        String string3 = ProjectContext.properties.getProperty("http.nonProxyHosts");
        String string4 = ProjectContext.properties.getProperty("https.proxyHost");
        String string5 = ProjectContext.properties.getProperty("https.proxyPort");
        String string6 = ProjectContext.properties.getProperty("https.nonProxyHosts");
        String string7 = ProjectContext.properties.getProperty("ftp.proxyHost");
        String string8 = ProjectContext.properties.getProperty("ftp.proxyPort");
        String string9 = ProjectContext.properties.getProperty("ftp.nonProxyHosts");
        String string10 = ProjectContext.properties.getProperty("socks.proxyHost");
        String string11 = ProjectContext.properties.getProperty("socks.proxyPort");
        String string12 = ProjectContext.properties.getProperty("proxy.username");
        String string13 = ProjectContext.properties.getProperty("proxy.password");
        if (!StringUtil.isEmpty(string)) {
            logger.info("http.proxyHost:{}", (Object)string);
            logger.info("http.proxyPort:{}", (Object)string2);
            logger.info("http.nonProxyHosts:{}", (Object)string3);
            properties.setProperty("http.proxyHost", string);
            properties.setProperty("http.proxyPort", string2);
            properties.setProperty("http.nonProxyHosts", string3);
        }
        if (!StringUtil.isEmpty(string4)) {
            logger.info("https.proxyHost:{}", (Object)string4);
            logger.info("https.proxyPort:{}", (Object)string5);
            logger.info("https.nonProxyHosts:{}", (Object)string6);
            properties.setProperty("https.proxyHost", string4);
            properties.setProperty("https.proxyPort", string5);
            properties.setProperty("https.nonProxyHosts", string6);
        }
        if (!StringUtil.isEmpty(string7)) {
            logger.info("ftp.proxyHost:{}", (Object)string7);
            logger.info("ftp.proxyPort:{}", (Object)string8);
            logger.info("ftp.nonProxyHosts:{}", (Object)string9);
            properties.setProperty("ftp.proxyHost", string7);
            properties.setProperty("ftp.proxyPort", string8);
            properties.setProperty("ftp.nonProxyHosts", string9);
        }
        if (!StringUtil.isEmpty(string10)) {
            logger.info("socks.proxyHost:{}", (Object)string10);
            logger.info("socks.proxyPort:{}", (Object)string11);
            properties.setProperty("socksProxyHost", string10);
            properties.setProperty("socksProxyPort", string11);
        }
        if (!StringUtil.isEmpty(string12)) {
            logger.info("proxy.username:{}", (Object)string12);
            final String string14 = string12;
            final String string15 = string13;
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string14, string15.toCharArray());
                }
            });
        }
    }
}

