/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.context;

import com.jsmframe.context.ProjectContext;
import com.jsmframe.context.SpringContext;
import com.jsmframe.context.WebContext;
import com.jsmframe.service.JsmAppListenerService;
import com.jsmframe.utils.LogUtil;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;

public class JsmInitListener
implements ServletContextListener {
    private static Logger logger = LogUtil.log(JsmInitListener.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        JsmAppListenerService jsmAppListenerService = SpringContext.getBean(JsmAppListenerService.class);
        if (jsmAppListenerService != null) {
            jsmAppListenerService.close(servletContextEvent);
        }
        logger.info("app close complete!");
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        WebContext.setContextPath(servletContextEvent.getServletContext().getContextPath());
        WebContext.setRealPath(servletContextEvent.getServletContext().getRealPath("/"));
        System.setProperty("file.encoding", "utf-8");
        ProjectContext.init();
        logger.info("jsm-frame init complete!");
        JsmAppListenerService jsmAppListenerService = SpringContext.getBean(JsmAppListenerService.class);
        if (jsmAppListenerService != null) {
            jsmAppListenerService.init(servletContextEvent);
        }
        this.appContextInitialized(servletContextEvent);
        logger.info("app init complete!");
    }

    protected void appContextInitialized(ServletContextEvent servletContextEvent) {
    }
}

