/*
 * Decompiled with CFR 0.152.
 */
package com.jsmframe.context;

import com.jsmframe.context.ProjectContext;
import com.jsmframe.utils.LogUtil;
import com.jsmframe.utils.PropUtil;
import com.jsmframe.utils.StringUtil;
import java.util.Properties;
import org.slf4j.Logger;

public class AppContext {
    private static Logger logger = LogUtil.log(AppContext.class);
    private static String propFile = "app.properties";
    private static Properties properties;

    public static String get(String string) {
        if (ProjectContext.isDevModel() || properties == null) {
            properties = PropUtil.getProperties(propFile);
        }
        return properties.getProperty(string);
    }

    public static Integer getAsInteger(String string) {
        try {
            String string2 = AppContext.get(string);
            if (!StringUtil.isEmpty(string2)) {
                return Integer.valueOf(string2);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
        catch (Exception exception) {
            logger.error("getAsInteter error! key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
    }

    public static Long getAsLong(String string) {
        try {
            String string2 = AppContext.get(string);
            if (!StringUtil.isEmpty(string2)) {
                return Long.valueOf(string2);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
        catch (Exception exception) {
            logger.error("getAsLong error! key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
    }

    public static Boolean getAsBoolean(String string) {
        try {
            String string2 = AppContext.get(string);
            if (!StringUtil.isEmpty(string2)) {
                return Boolean.valueOf(string2);
            }
            logger.error("key is empty, key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
        catch (Exception exception) {
            logger.error("getAsBoolean error! key {} in propFile {}", (Object)string, (Object)propFile);
            return null;
        }
    }
}

